/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public class SPacketSyncChampion {
    private int entityId;
    private int tier;
    private int defaultColor;
    private Set<String> affixes;
    private int affixSize;

    public SPacketSyncChampion(int entityId, int tier, int defaultColor, Set<String> affixes) {
        this.entityId = entityId;
        this.tier = tier;
        this.affixSize = affixes.size();
        this.affixes = affixes;
        this.defaultColor = defaultColor;
    }

    public static void encode(SPacketSyncChampion msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.tier);
        buf.writeInt(msg.affixSize);
        buf.writeInt(msg.defaultColor);
        msg.affixes.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
    }

    public static SPacketSyncChampion decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        int tier = buf.readInt();
        HashSet<String> affixes = new HashSet<String>();
        int affixSize = buf.readInt();
        int defaultColor = buf.readInt();
        for (int i = 0; i < affixSize; ++i) {
            affixes.add(buf.func_218666_n());
        }
        return new SPacketSyncChampion(entityId, tier, defaultColor, affixes);
    }

    public static void handle(SPacketSyncChampion msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(msg.entityId)) instanceof LivingEntity) {
                ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    clientChampion.setRank((Tuple<Integer, Integer>)new Tuple((Object)msg.tier, (Object)msg.defaultColor));
                    clientChampion.setAffixes(msg.affixes);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

