/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.integration.gamestages.ChampionsStages;
import top.theillusivec4.champions.common.integration.scalinghealth.ScalingHealthManager;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.EntityManager;

public class ChampionBuilder {
    private static final Random RAND = new Random();

    public static void spawn(IChampion champion) {
        LivingEntity entity = champion.getLivingEntity();
        Rank newRank = ChampionBuilder.createRank(entity);
        champion.getServer().setRank(newRank);
        ChampionBuilder.applyGrowth(entity, newRank.getGrowthFactor());
        List<IAffix> newAffixes = ChampionBuilder.createAffixes(newRank, champion);
        champion.getServer().setAffixes(newAffixes);
        newAffixes.forEach(affix -> affix.onInitialSpawn(champion));
    }

    public static void spawnPreset(IChampion champion, int tier, List<IAffix> affixes) {
        LivingEntity entity = champion.getLivingEntity();
        Rank newRank = RankManager.getRank(tier);
        champion.getServer().setRank(newRank);
        ChampionBuilder.applyGrowth(entity, newRank.getGrowthFactor());
        affixes = affixes.isEmpty() ? ChampionBuilder.createAffixes(newRank, champion) : affixes;
        champion.getServer().setAffixes(affixes);
        affixes.forEach(affix -> affix.onInitialSpawn(champion));
    }

    public static List<IAffix> createAffixes(Rank rank, IChampion champion) {
        int size = rank.getNumAffixes();
        ArrayList<IAffix> affixesToAdd = new ArrayList<IAffix>();
        Optional<EntityManager.EntitySettings> entitySettings = EntityManager.getSettings(champion.getLivingEntity().func_200600_R());
        if (size > 0) {
            entitySettings.ifPresent(settings -> {
                if (settings.presetAffixes != null) {
                    affixesToAdd.addAll(settings.presetAffixes);
                }
            });
            rank.getPresetAffixes().forEach(affix -> {
                if (!affixesToAdd.contains(affix)) {
                    affixesToAdd.add((IAffix)affix);
                }
            });
        }
        Map<AffixCategory, List<IAffix>> allAffixes = Champions.API.getCategoryMap();
        HashMap<AffixCategory, List> validAffixes = new HashMap<AffixCategory, List>();
        for (AffixCategory category : Champions.API.getCategories()) {
            validAffixes.put(category, new ArrayList());
        }
        allAffixes.forEach((k, v) -> ((List)validAffixes.get(k)).addAll(v.stream().filter(affix -> {
            Optional<AffixManager.AffixSettings> settings = AffixManager.getSettings(affix.getIdentifier());
            return !affixesToAdd.contains(affix) && entitySettings.map(entitySettings1 -> entitySettings1.canApply((IAffix)affix)).orElse(true) != false && settings.map(affixSettings -> affixSettings.canApply(champion)).orElse(true) != false && affix.canApply(champion);
        }).collect(Collectors.toList())));
        ArrayList randomList = new ArrayList();
        validAffixes.forEach((k, v) -> randomList.addAll(v));
        while (randomList.size() > 0 && affixesToAdd.size() < size) {
            int randomIndex = RAND.nextInt(randomList.size());
            IAffix randomAffix = (IAffix)randomList.get(randomIndex);
            if (affixesToAdd.stream().allMatch(affix -> affix.isCompatible(randomAffix) && (randomAffix.getCategory() == AffixCategory.OFFENSE || affix.getCategory() != randomAffix.getCategory()))) {
                affixesToAdd.add(randomAffix);
            }
            randomList.remove(randomIndex);
        }
        return affixesToAdd;
    }

    public static Rank createRank(LivingEntity livingEntity) {
        if (!ChampionHelper.checkPotential(livingEntity)) {
            return RankManager.getLowestRank();
        }
        Integer[] tierRange = new Integer[]{null, null};
        EntityManager.getSettings(livingEntity.func_200600_R()).ifPresent(entitySettings -> {
            tierRange[0] = entitySettings.minTier;
            tierRange[1] = entitySettings.maxTier;
        });
        ImmutableSortedMap<Integer, Rank> ranks = RankManager.getRanks();
        Integer firstTier = tierRange[0] != null ? tierRange[0] : (Integer)ranks.firstKey();
        int maxTier = tierRange[1] != null ? tierRange[1] : -1;
        UnmodifiableIterator iter = ranks.navigableKeySet().tailSet((Object)firstTier, false).iterator();
        Rank result = (Rank)ranks.get((Object)firstTier);
        while (iter.hasNext() && (result.getTier() < maxTier || maxTier == -1)) {
            Rank rank = (Rank)ranks.get(iter.next());
            float chance = rank.getChance();
            if (Champions.scalingHealthLoaded) {
                chance = (float)((double)chance + ScalingHealthManager.getSpawnIncrease(rank.getTier(), livingEntity));
            }
            if (RAND.nextFloat() < chance && (!Champions.gameStagesLoaded || ChampionsStages.hasTierStage(rank.getTier(), livingEntity))) {
                result = rank;
                continue;
            }
            return result;
        }
        return result != null ? result : RankManager.getLowestRank();
    }

    public static void applyGrowth(LivingEntity livingEntity, int growthFactor) {
        if (growthFactor < 1) {
            return;
        }
        ChampionBuilder.grow(livingEntity, Attributes.field_233818_a_, ChampionsConfig.healthGrowth * (double)growthFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
        livingEntity.func_70606_j(livingEntity.func_110138_aP());
        ChampionBuilder.grow(livingEntity, Attributes.field_233823_f_, ChampionsConfig.attackGrowth * (double)growthFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ChampionBuilder.grow(livingEntity, Attributes.field_233826_i_, ChampionsConfig.armorGrowth * (double)growthFactor, AttributeModifier.Operation.ADDITION);
        ChampionBuilder.grow(livingEntity, Attributes.field_233827_j_, ChampionsConfig.toughnessGrowth * (double)growthFactor, AttributeModifier.Operation.ADDITION);
        ChampionBuilder.grow(livingEntity, Attributes.field_233820_c_, ChampionsConfig.knockbackResistanceGrowth * (double)growthFactor, AttributeModifier.Operation.ADDITION);
    }

    private static void grow(LivingEntity livingEntity, Attribute attribute, double amount, AttributeModifier.Operation operation) {
        ModifiableAttributeInstance attributeInstance = livingEntity.func_110148_a(attribute);
        if (attributeInstance != null) {
            double oldMax = attributeInstance.func_111125_b();
            double newMax = 0.0;
            switch (operation) {
                case ADDITION: {
                    newMax = oldMax + amount;
                    break;
                }
                case MULTIPLY_BASE: {
                    newMax = oldMax * amount;
                    break;
                }
                case MULTIPLY_TOTAL: {
                    newMax = oldMax * (1.0 + amount);
                }
            }
            attributeInstance.func_111128_a(newMax);
        }
    }
}

