/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.TranslationTextComponent;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;

public class AffixArgument
implements ArgumentType<IAffixProvider> {
    private static final Collection<String> EXAMPLES = Arrays.asList("molten", "reflecting");
    private static final DynamicCommandExceptionType UNKNOWN_AFFIX = new DynamicCommandExceptionType(type -> new TranslationTextComponent("argument.champions.affix.unknown", new Object[]{type}));

    public static AffixArgument affix() {
        return new AffixArgument();
    }

    public static Collection<IAffix> getAffixes(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ((IAffixProvider)context.getArgument(name, IAffixProvider.class)).getAffixes((CommandSource)context.getSource());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public IAffixProvider parse(StringReader reader) throws CommandSyntaxException {
        String s = reader.getString().substring(reader.getCursor(), reader.getTotalLength());
        String[] split = s.split(" ");
        ArrayList<IAffix> affixes = new ArrayList<IAffix>();
        for (String id : split) {
            affixes.add(Champions.API.getAffix(id).orElseThrow(() -> UNKNOWN_AFFIX.create((Object)id)));
        }
        while (reader.canRead()) {
            reader.skip();
        }
        return source -> affixes;
    }

    @FunctionalInterface
    public static interface IAffixProvider {
        public Collection<IAffix> getAffixes(CommandSource var1) throws CommandSyntaxException;
    }
}

