/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.aabb;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.aabb.AABBCompressor;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import net.minecraft.util.math.AxisAlignedBB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AABBManager {
    private static final AABBManager INSTANCE = new AABBManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Cache<Key, Collection<AxisAlignedBB>> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static AABBManager getInstance() {
        return INSTANCE;
    }

    private AABBManager() {
    }

    public Collection<AxisAlignedBB> get(IAreaAccessor accessor, Function<IAreaAccessor, Predicate<IStateEntryInfo>> selectablePredicateBuilder) {
        Predicate<IStateEntryInfo> selectablePredicate = selectablePredicateBuilder.apply(accessor);
        Key cacheKey = new Key(accessor.createNewShapeIdentifier(), selectablePredicate);
        try {
            return (Collection)this.cache.get((Object)cacheKey, () -> AABBCompressor.compressStates(accessor, selectablePredicate));
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to calculate the bounding boxes for an area.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final Predicate<IStateEntryInfo> predicate;

        private Key(IAreaShapeIdentifier identifier, Predicate<IStateEntryInfo> predicate) {
            this.identifier = identifier;
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.identifier, key.identifier) && Objects.equals(this.predicate, key.predicate);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.predicate);
        }
    }
}

