/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.chiseling.mode;

import java.util.Optional;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.IToolMode;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.registries.IRegistryManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IChiselMode
extends IForgeRegistryEntry<IChiselMode>,
IToolMode<IToolModeGroup> {
    public static IChiselMode getDefaultMode() {
        return IChiselsAndBitsAPI.getInstance().getDefaultChiselMode();
    }

    public static IForgeRegistry<IChiselMode> getRegistry() {
        return IRegistryManager.getInstance().getChiselModeRegistry();
    }

    public ClickProcessingState onLeftClickBy(PlayerEntity var1, IChiselingContext var2);

    public void onStoppedLeftClicking(PlayerEntity var1, IChiselingContext var2);

    public ClickProcessingState onRightClickBy(PlayerEntity var1, IChiselingContext var2);

    public void onStoppedRightClicking(PlayerEntity var1, IChiselingContext var2);

    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext var1);

    default public boolean isStillValid(PlayerEntity playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        IChiselingContext snapshot = IChiselingManager.getInstance().create(playerEntity, this, modeOfOperation, true, ItemStack.field_190927_a);
        if (modeOfOperation == ChiselingOperation.CHISELING) {
            this.onLeftClickBy(playerEntity, snapshot);
        } else {
            this.onRightClickBy(playerEntity, snapshot);
        }
        if (!snapshot.getMutator().isPresent()) {
            return !context.getMutator().isPresent();
        }
        if (!context.getMutator().isPresent()) {
            return false;
        }
        return context.getMutator().get().getInWorldBoundingBox().equals((Object)snapshot.getMutator().get().getInWorldBoundingBox());
    }
}

