/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.config;

import mod.chiselsandbits.api.config.AbstractConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfiguration
extends AbstractConfiguration {
    public ForgeConfigSpec.BooleanValue enableRightClickModeChange;
    public ForgeConfigSpec.BooleanValue invertBitBagFullness;
    public ForgeConfigSpec.BooleanValue enableToolbarIcons;
    public ForgeConfigSpec.BooleanValue perChiselMode;
    public ForgeConfigSpec.BooleanValue chatModeNotification;
    public ForgeConfigSpec.BooleanValue itemNameModeDisplay;
    public ForgeConfigSpec.BooleanValue addBrokenBlocksToCreativeClipboard;
    public ForgeConfigSpec.IntValue maxUndoLevel;
    public ForgeConfigSpec.IntValue maxTapeMeasures;
    public ForgeConfigSpec.BooleanValue displayMeasuringTapeInChat;
    public ForgeConfigSpec.DoubleValue radialMenuVolume;
    public ForgeConfigSpec.LongValue bitStorageContentCacheSize;
    public ForgeConfigSpec.DoubleValue maxDrawnRegionSize;
    public ForgeConfigSpec.BooleanValue enableFaceLightmapExtraction;
    public ForgeConfigSpec.BooleanValue useGetLightValue;
    public ForgeConfigSpec.BooleanValue disableCustomVertexFormats;
    public ForgeConfigSpec.BooleanValue enableMouseIndicatorInRadialMenu;
    public ForgeConfigSpec.LongValue modelCacheSize;
    public ForgeConfigSpec.BooleanValue injectIntoJEI;

    protected ClientConfiguration(ForgeConfigSpec.Builder builder) {
        ClientConfiguration.createCategory(builder, "client.settings");
        this.enableRightClickModeChange = ClientConfiguration.defineBoolean(builder, "enable-right-click-mode-change", false);
        this.invertBitBagFullness = ClientConfiguration.defineBoolean(builder, "invert-bit-bag-fullness", false);
        this.enableToolbarIcons = ClientConfiguration.defineBoolean(builder, "enable.toolbar.icons", true);
        this.perChiselMode = ClientConfiguration.defineBoolean(builder, "per-chisel-mode", true);
        this.chatModeNotification = ClientConfiguration.defineBoolean(builder, "chat-mode-notification", true);
        this.itemNameModeDisplay = ClientConfiguration.defineBoolean(builder, "item-name-mode-display", true);
        this.addBrokenBlocksToCreativeClipboard = ClientConfiguration.defineBoolean(builder, "clipboard.add-broken-blocks", false);
        this.maxUndoLevel = ClientConfiguration.defineInteger(builder, "undo.max-count", 10);
        this.maxTapeMeasures = ClientConfiguration.defineInteger(builder, "tape-measure.max-count", 10);
        this.displayMeasuringTapeInChat = ClientConfiguration.defineBoolean(builder, "tape-measure.display-in-chat", true);
        this.radialMenuVolume = ClientConfiguration.defineDouble(builder, "radial.menu.volume", 0.1f);
        ClientConfiguration.finishCategory(builder);
        ClientConfiguration.createCategory(builder, "client.performance");
        this.bitStorageContentCacheSize = ClientConfiguration.defineLong(builder, "bit-storage.contents.cache.size", 100L, 0L, Long.MAX_VALUE);
        this.maxDrawnRegionSize = ClientConfiguration.defineDouble(builder, "max-drawn-region.size", 4.0);
        this.enableFaceLightmapExtraction = ClientConfiguration.defineBoolean(builder, "lighting.face-lightmap-extraction", true);
        this.useGetLightValue = ClientConfiguration.defineBoolean(builder, "lighting.use-value", true);
        this.disableCustomVertexFormats = ClientConfiguration.defineBoolean(builder, "vertexformats.custom.disabled", true);
        this.modelCacheSize = ClientConfiguration.defineLong(builder, "models.cache.size", 1000L, 0L, 2000L);
        ClientConfiguration.finishCategory(builder);
        ClientConfiguration.createCategory(builder, "client.gui");
        this.enableMouseIndicatorInRadialMenu = ClientConfiguration.defineBoolean(builder, "radial-menu.mouse-indicator", false);
        ClientConfiguration.finishCategory(builder);
        ClientConfiguration.createCategory(builder, "compat.jei");
        this.injectIntoJEI = ClientConfiguration.defineBoolean(builder, "inject-bits", true);
        ClientConfiguration.finishCategory(builder);
    }
}

