/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.config;

import java.util.List;
import mod.chiselsandbits.api.config.AbstractConfiguration;
import mod.chiselsandbits.api.util.LocalStrings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration
extends AbstractConfiguration {
    public ForgeConfigSpec.BooleanValue enableHelp;
    public ForgeConfigSpec.LongValue collisionBoxCacheSize;

    public CommonConfiguration(ForgeConfigSpec.Builder builder) {
        CommonConfiguration.createCategory(builder, "common.help");
        this.enableHelp = CommonConfiguration.defineBoolean(builder, "common.help.enabled", true);
        CommonConfiguration.finishCategory(builder);
        CommonConfiguration.createCategory(builder, "common.performance");
        this.collisionBoxCacheSize = CommonConfiguration.defineLong(builder, "common.performance.collisions.cache.size", 10000L);
        CommonConfiguration.finishCategory(builder);
    }

    public void helpText(LocalStrings string, List<ITextComponent> tooltip, String ... variables) {
        if (((Boolean)this.enableHelp.get()).booleanValue()) {
            String[] lines;
            int varOffset = 0;
            for (String a : lines = string.getLocal().split(";")) {
                while (a.contains("{}") && variables.length > varOffset) {
                    int offset = a.indexOf("{}");
                    if (offset < 0) continue;
                    String pre = a.substring(0, offset);
                    String post = a.substring(offset + 2);
                    a = String.format("%s%s%s", pre, variables[varOffset++], post);
                }
                tooltip.add((ITextComponent)new StringTextComponent(a));
            }
        }
    }
}

