/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.data.tag;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.tags.TagJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.constants.Constants;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChiselableTagGenerator
implements IDataProvider {
    private final DataGenerator generator;
    private final Mode mode;
    private final List<Block> blocks;

    protected AbstractChiselableTagGenerator(DataGenerator generator, Mode mode, List<Block> blocks) {
        this.generator = generator;
        this.mode = mode;
        this.blocks = blocks;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        TagJson json = new TagJson();
        json.setValues(this.blocks.stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
        Path tagFolder = this.generator.func_200391_b().resolve("data/chiselsandbits/tags/blocks/");
        Path chiselableTagPath = tagFolder.resolve("chiselable/" + this.mode.toString().toLowerCase() + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)json.serialize(), (Path)chiselableTagPath);
    }

    @NotNull
    public String func_200397_b() {
        return StringUtils.capitalize((String)this.mode.toString().toLowerCase(Locale.ROOT)) + " chiselable tag generator";
    }

    public static enum Mode {
        FORCED,
        BLOCKED;

    }
}

