/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import java.util.Objects;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.block.BitStorageBlock;
import mod.chiselsandbits.registrars.ModTileEntityTypes;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitStorageBlockEntity
extends TileEntity
implements IItemHandler,
IFluidHandler {
    public static final int MAX_CONTENTS = 4096;
    public static final int MB_PER_BIT_CONVERSION = 125;
    public static final int BITS_PER_MB_CONVERSION = 512;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this);
    private BlockState state = null;
    private Fluid myFluid = null;
    private int bits = 0;
    private int oldLV = -1;

    public BitStorageBlockEntity() {
        super((TileEntityType)ModTileEntityTypes.BIT_STORAGE.get());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public void func_230337_a_(@Nullable BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        String fluid = nbt.func_74779_i("fluid");
        if (fluid.equals("")) {
            if (nbt.func_74764_b("state")) {
                CompoundNBT stateCompound = nbt.func_74775_l("state");
                this.state = NBTUtil.func_190008_d((CompoundNBT)stateCompound);
            } else {
                int rawState = nbt.func_74762_e("blockstate");
                this.state = rawState != -1 ? IBlockStateIdManager.getInstance().getBlockStateFrom(rawState) : null;
            }
        } else {
            this.myFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid));
            this.state = this.myFluid.func_207188_f().func_206883_i();
        }
        this.bits = nbt.func_74762_e("bits");
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74778_a("fluid", this.myFluid == null ? "" : Objects.requireNonNull(this.myFluid.getRegistryName()).toString());
        nbt.func_218657_a("state", (INBT)(this.myFluid != null || this.state == null ? new CompoundNBT() : NBTUtil.func_190009_a((BlockState)this.state)));
        nbt.func_74768_a("bits", this.bits);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT t = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(t));
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        return this.func_189515_b(nbttagcompound);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (this.bits > 0 && slot == 0 && (this.myFluid != null || this.state != null)) {
            if (this.myFluid != null) {
                return this.getFluidBitStack(this.myFluid, this.bits);
            }
            return this.getBlockBitStack(this.state, this.bits);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        BlockState stackState;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IBitItem) {
            IBitItem bitItem = (IBitItem)stack.func_77973_b();
            BlockState blk = bitItem.getBitState(stack);
            ItemStack fluidInsertion = this.attemptFluidBitStackInsertion(stack, simulate, blk);
            if (fluidInsertion != stack) {
                return fluidInsertion;
            }
            return this.attemptSolidBitStackInsertion(stack, simulate, blk);
        }
        if (!stack.func_190926_b() && IEligibilityManager.getInstance().analyse((IItemProvider)stack.func_77973_b()).canBeChiseled() && this.myFluid == null && (stackState = ItemStackUtils.getStateFromItem(stack)).func_177230_c() != Blocks.field_150350_a && (this.state == null || this.state.isAir((IBlockReader)new SingleBlockBlockReader(this.state, this.func_174877_v(), (IBlockReader)this.func_145831_w()), this.func_174877_v()))) {
            this.state = stackState;
            this.bits = 4096;
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractBits(slot, Math.min(amount, IBitItemManager.getInstance().getMaxStackSize()), simulate);
    }

    public int getSlotLimit(int slot) {
        return 512;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IBitItem || IEligibilityManager.getInstance().canBeChiseled((IItemProvider)stack.func_77973_b()));
    }

    @NotNull
    private ItemStack attemptFluidBitStackInsertion(ItemStack stack, boolean simulate, BlockState blk) {
        boolean canInsert;
        Fluid f = null;
        for (Fluid fl : ForgeRegistries.FLUIDS) {
            if (fl.func_207188_f().func_206883_i().func_177230_c() != blk.func_177230_c()) continue;
            f = fl;
            break;
        }
        if (f == null) {
            return stack;
        }
        ItemStack bitItem = this.getFluidBitStack(this.myFluid, this.bits);
        boolean bl = canInsert = bitItem.func_190926_b() || ItemStack.func_77970_a((ItemStack)bitItem, (ItemStack)stack) && bitItem.func_77973_b() == stack.func_77973_b() || this.state == null;
        if (canInsert) {
            int merged = this.bits + stack.func_190916_E();
            int amount = Math.min(merged, 4096);
            if (!simulate) {
                Fluid oldFluid = this.myFluid;
                BlockState oldState = this.state;
                int oldBits = this.bits;
                this.myFluid = f;
                this.state = this.myFluid.func_207188_f().func_206883_i();
                this.bits = amount;
                if (this.bits != oldBits || this.myFluid != oldFluid || oldState != null) {
                    this.saveAndUpdate();
                }
            }
            if (amount < merged) {
                ItemStack out = stack.func_77946_l();
                out.func_190920_e(merged - amount);
                return out;
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @NotNull
    private ItemStack attemptSolidBitStackInsertion(ItemStack stack, boolean simulate, BlockState blk) {
        boolean canInsert;
        Fluid f = null;
        for (Fluid fl : ForgeRegistries.FLUIDS) {
            if (fl.func_207188_f().func_206883_i().func_177230_c() != blk.func_177230_c()) continue;
            f = fl;
            break;
        }
        if (f != null) {
            return stack;
        }
        ItemStack bitItem = this.getBlockBitStack(blk, this.bits);
        boolean bl = canInsert = bitItem.func_190926_b() || ItemStack.func_77970_a((ItemStack)bitItem, (ItemStack)stack) && bitItem.func_77973_b() == stack.func_77973_b();
        if (canInsert) {
            int merged = this.bits + stack.func_190916_E();
            int amount = Math.min(merged, 4096);
            if (!simulate) {
                Fluid oldFluid = this.myFluid;
                BlockState oldBlockState = this.state;
                int oldBits = this.bits;
                this.myFluid = null;
                this.state = blk;
                this.bits = amount;
                if (this.bits != oldBits || this.state != oldBlockState || oldFluid != null) {
                    this.saveAndUpdate();
                }
            }
            if (amount < merged) {
                ItemStack out = stack.func_77946_l();
                out.func_190920_e(merged - amount);
                return out;
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public FluidStack getBitsAsFluidStack() {
        if (this.myFluid == null && this.state != null) {
            return FluidStack.EMPTY;
        }
        if (this.bits > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, this.bits);
        }
        return null;
    }

    public boolean extractBits(PlayerEntity playerIn, double hitX, double hitY, double hitZ, BlockPos pos) {
        if (!playerIn.func_225608_bj_()) {
            ItemStack is = this.extractItem(0, 64, false);
            if (!is.func_190926_b() && is.func_77973_b() instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)is.func_77973_b();
                BlockState blockState = bitItem.getBitState(is);
                BitInventoryUtils.insertIntoOrSpawn(playerIn, blockState, is.func_190916_E());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack extractBits(int slot, int amount, boolean simulate) {
        ItemStack contents = this.getStackInSlot(slot);
        if (!contents.func_190926_b() && amount > 0) {
            contents.func_190920_e(Math.min(amount, contents.func_190916_E()));
            if (!simulate) {
                int oldBits = this.bits;
                this.bits -= contents.func_190916_E();
                if (this.bits <= 0) {
                    this.bits = 0;
                    this.state = null;
                    this.myFluid = null;
                }
                if (this.bits != oldBits) {
                    this.saveAndUpdate();
                }
            }
            return contents;
        }
        return ItemStack.field_190927_a;
    }

    private void saveAndUpdate() {
        if (this.field_145850_b == null || this.func_145831_w() == null) {
            return;
        }
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 0);
        int lv = this.getLightValue();
        if (this.oldLV != lv) {
            this.func_145831_w().func_225524_e_().func_215568_a(this.func_174877_v());
            this.oldLV = lv;
        }
    }

    @Nonnull
    public ItemStack getFluidBitStack(Fluid liquid, int amount) {
        if (liquid == null) {
            return ItemStack.field_190927_a;
        }
        return IBitItemManager.getInstance().create(liquid.func_207188_f().func_206883_i(), amount);
    }

    @Nonnull
    public ItemStack getBlockBitStack(BlockState blockState, int amount) {
        if (blockState == null || blockState.getBlockState() == null) {
            return ItemStack.field_190927_a;
        }
        return IBitItemManager.getInstance().create(blockState, amount);
    }

    public int getLightValue() {
        BlockState workingState;
        BlockState blockState = workingState = this.myFluid == null ? this.state : this.myFluid.func_207188_f().func_206883_i();
        if (workingState == null) {
            return 0;
        }
        return workingState.getLightValue((IBlockReader)new SingleBlockWorldReader(workingState, this.func_174877_v(), (IWorldReader)this.func_145831_w()), this.func_174877_v());
    }

    public boolean addAllPossibleBits(PlayerEntity playerIn) {
        if (playerIn != null && playerIn.func_225608_bj_() && this.state != null && !this.state.isAir((IBlockReader)new SingleBlockBlockReader(this.state, this.state.func_177230_c(), this.func_174877_v(), (IBlockReader)this.func_145831_w()), this.func_174877_v())) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(playerIn);
            int extractionAmount = Math.min(4096 - this.bits, bitInventory.getMaxExtractAmount(this.state));
            bitInventory.extract(this.state, extractionAmount);
            this.bits += extractionAmount;
            this.func_70296_d();
        }
        return false;
    }

    public boolean addHeldBits(@Nonnull ItemStack current, PlayerEntity playerIn) {
        if ((playerIn.func_225608_bj_() || this.bits == 0) && (current.func_77973_b() instanceof IBitItem || IEligibilityManager.getInstance().canBeChiseled((IItemProvider)current.func_77973_b()))) {
            ItemStack resultStack = this.insertItem(0, current, false);
            if (!playerIn.func_184812_l_()) {
                playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, resultStack);
                playerIn.field_71071_by.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getAccessableFluid();
    }

    public FluidStack getAccessableFluid() {
        if (this.myFluid == null && this.state != null) {
            return FluidStack.EMPTY;
        }
        int mb = (this.bits - this.bits % 512) / 512;
        if ((mb *= 125) > 0 && this.myFluid != null) {
            return new FluidStack(this.myFluid, mb);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 4096;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (this.getAccessableFluid().isEmpty() && this.state == null) {
            return true;
        }
        if (this.state != null) {
            return false;
        }
        return Objects.equals(this.getAccessableFluid().getFluid().getRegistryName(), stack.getFluid().getRegistryName());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || this.state != null) {
            return 0;
        }
        int possibleAmount = resource.getAmount() - resource.getAmount() % 125;
        if (possibleAmount > 0) {
            int bitCount = possibleAmount * 512 / 125;
            ItemStack bitItems = this.getFluidBitStack(resource.getFluid(), bitCount);
            ItemStack leftOver = this.insertItem(0, bitItems, action.simulate());
            if (leftOver.func_190926_b()) {
                return possibleAmount;
            }
            int mbUsedUp = leftOver.func_190916_E();
            mbUsedUp *= 125;
            mbUsedUp += 511;
            return resource.getAmount() - (mbUsedUp /= 512);
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || this.state != null) {
            return FluidStack.EMPTY;
        }
        FluidStack a = this.getAccessableFluid();
        if (a != null && resource.containsFluid(a)) {
            int aboutHowMuch = resource.getAmount();
            int mbThatCanBeRemoved = Math.min(a.getAmount(), aboutHowMuch - aboutHowMuch % 125);
            if (mbThatCanBeRemoved > 0) {
                a.setAmount(mbThatCanBeRemoved);
                if (action.execute()) {
                    int bitCount = mbThatCanBeRemoved * 512 / 125;
                    this.extractBits(0, bitCount, false);
                }
                return a;
            }
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.state != null) {
            return FluidStack.EMPTY;
        }
        FluidStack a = this.getAccessableFluid();
        if (a != null) {
            int aboutHowMuch = maxDrain;
            int mbThatCanBeRemoved = Math.min(a.getAmount(), aboutHowMuch - aboutHowMuch % 125);
            if (mbThatCanBeRemoved > 0) {
                a.setAmount(mbThatCanBeRemoved);
                if (action.execute()) {
                    int bitCount = mbThatCanBeRemoved * 512 / 125;
                    this.extractBits(0, bitCount, false);
                }
                return a;
            }
        }
        return FluidStack.EMPTY;
    }

    public BlockState getState() {
        return this.state;
    }

    public Fluid getMyFluid() {
        return this.myFluid;
    }

    public int getBits() {
        return this.bits;
    }

    public Direction getFacing() {
        return (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BitStorageBlock.FACING);
    }
}

