/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.eligibility;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import mod.chiselsandbits.api.IgnoreBlockLogic;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityAnalysisResult;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.ChiseledBlock;
import mod.chiselsandbits.chiseling.eligibility.BlockEligibilityAnalysisData;
import mod.chiselsandbits.chiseling.eligibility.EligibilityAnalysisResult;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModTags;
import mod.chiselsandbits.utils.ClassUtils;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EligibilityManager
implements IEligibilityManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EligibilityManager INSTANCE = new EligibilityManager();
    private static final Cache<BlockState, IEligibilityAnalysisResult> cache = CacheBuilder.newBuilder().maximumSize(1000000L).build();

    private EligibilityManager() {
    }

    public static EligibilityManager getInstance() {
        return INSTANCE;
    }

    @Override
    public IEligibilityAnalysisResult analyse(@NotNull BlockState state) {
        try {
            return (IEligibilityAnalysisResult)cache.get((Object)state, () -> {
                if (state.func_177230_c() instanceof ChiseledBlock) {
                    return new EligibilityAnalysisResult(false, true, TranslationUtils.build("chiseling.is-already-chiseled", new Object[0]));
                }
                Block blk = state.func_177230_c();
                if (blk.func_203417_a(ModTags.Blocks.BLOCKED_CHISELABLE)) {
                    return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportTagBlackListed, new Object[0]));
                }
                if (blk.func_203417_a(ModTags.Blocks.FORCED_CHISELABLE)) {
                    return new EligibilityAnalysisResult(true, false, TranslationUtils.build(LocalStrings.ChiselSupportTagWhitelisted, new Object[0]));
                }
                try {
                    ReflectionHelperBlock pb = new ReflectionHelperBlock();
                    Class<?> blkClass = blk.getClass();
                    pb.func_220076_a(state, null);
                    Class<?> wc = ClassUtils.getDeclaringClass(blkClass, pb.MethodName, BlockState.class, LootContext.Builder.class);
                    boolean quantityDroppedTest = wc == Block.class || wc == AbstractBlock.class || wc == FlowingFluidBlock.class;
                    boolean isNotSlab = Item.func_150898_a((Block)blk) != Items.field_190931_a || state.func_177230_c() instanceof FlowingFluidBlock;
                    boolean itemExistsOrNotSpecialDrops = quantityDroppedTest || isNotSlab;
                    pb.func_220053_a(null, null, null, null);
                    Class<?> collisionClass = ClassUtils.getDeclaringClass(blkClass, pb.MethodName, BlockState.class, IBlockReader.class, BlockPos.class, ISelectionContext.class);
                    boolean noCustomCollision = collisionClass == Block.class || collisionClass == AbstractBlock.class || blk.getClass() == SlimeBlock.class || collisionClass == FlowingFluidBlock.class;
                    boolean isFullBlock = state.func_200132_m() || blk instanceof AbstractGlassBlock || blk instanceof FlowingFluidBlock;
                    BlockEligibilityAnalysisData info = BlockEligibilityAnalysisData.createFromState(state);
                    boolean tickingBehavior = blk.func_149653_t(state) && (Boolean)Configuration.getInstance().getServer().blackListRandomTickingBlocks.get() != false;
                    boolean hasBehavior = blk.hasTileEntity(state) || tickingBehavior;
                    Material remappedMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(state.func_185904_a());
                    boolean supportedMaterial = ModBlocks.MATERIAL_TO_BLOCK_CONVERSIONS.containsKey(remappedMaterial);
                    if (!supportedMaterial) {
                        return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericNotSupported, new Object[0]));
                    }
                    if (blkClass.isAnnotationPresent(IgnoreBlockLogic.class)) {
                        isFullBlock = true;
                        noCustomCollision = true;
                        hasBehavior = false;
                        itemExistsOrNotSpecialDrops = true;
                    }
                    if (info.isCompatible() && noCustomCollision && info.getHardness() >= -0.01f && isFullBlock && supportedMaterial && !hasBehavior && itemExistsOrNotSpecialDrops) {
                        return new EligibilityAnalysisResult(true, false, TranslationUtils.build(blkClass.isAnnotationPresent(IgnoreBlockLogic.class) ? LocalStrings.ChiselSupportLogicIgnored : LocalStrings.ChiselSupportGenericSupported, new Object[0]));
                    }
                    if (!state.func_204520_s().func_206888_e()) {
                        return new EligibilityAnalysisResult(true, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericFluidSupport, new Object[0]));
                    }
                    EligibilityAnalysisResult result = null;
                    if (!info.isCompatible()) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportCompatDeactivated, new Object[0]));
                    } else if (!noCustomCollision) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportCustomCollision, new Object[0]));
                    } else if (info.getHardness() < -0.01f) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportNoHardness, new Object[0]));
                    } else if (!isNotSlab) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportIsSlab, new Object[0]));
                    } else if (!isFullBlock) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportNotFullBlock, new Object[0]));
                    } else if (hasBehavior) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportHasBehaviour, new Object[0]));
                    } else if (!quantityDroppedTest) {
                        result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportHasCustomDrops, new Object[0]));
                    }
                    return result;
                }
                catch (Throwable t) {
                    return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportFailureToAnalyze, new Object[0]));
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to perform eligibility analysis.", (Throwable)e);
            return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportFailureToAnalyze, new Object[0]));
        }
    }

    @Override
    public IEligibilityAnalysisResult analyse(@NotNull IItemProvider provider) {
        Item item = provider.func_199767_j();
        if (item instanceof BlockItem) {
            return this.analyse(((BlockItem)item).func_179223_d());
        }
        return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericNotSupported, new Object[0]));
    }
}

