/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.besr;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.util.FluidCuboidUtils;
import mod.chiselsandbits.utils.ChunkSectionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.FluidState;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class BitStorageBESR
extends TileEntityRenderer<BitStorageBlockEntity> {
    private static final SimpleMaxSizedCache<CacheKey, ChunkSection> STORAGE_CONTENTS_BLOB_CACHE = new SimpleMaxSizedCache((Long)Configuration.getInstance().getClient().bitStorageContentCacheSize.get());

    public BitStorageBESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BitStorageBlockEntity te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState state;
        if (te.getMyFluid() != null) {
            FluidStack fluidStack = te.getBitsAsFluidStack();
            if (fluidStack != null) {
                RenderType.func_228661_n_().forEach(renderType -> {
                    if (!RenderTypeLookup.canRenderInLayer((FluidState)fluidStack.getFluid().func_207188_f(), (RenderType)renderType)) {
                        return;
                    }
                    if (renderType == RenderType.func_228645_f_() && Minecraft.func_238218_y_()) {
                        renderType = Atlases.func_228785_j_();
                    }
                    IVertexBuilder builder = buffer.getBuffer(renderType);
                    float fullness = (float)fluidStack.getAmount() / 4096.0f;
                    FluidCuboidUtils.renderScaledFluidCuboid(fluidStack, matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 15.0f, 15.0f * fullness, 15.0f);
                });
            }
            return;
        }
        int bits = te.getBits();
        BlockState blockState = state = te.getMyFluid() == null ? te.getState() : te.getMyFluid().func_207188_f().func_206883_i();
        if (bits <= 0 || state == null) {
            return;
        }
        CacheKey cacheKey = new CacheKey(IBlockStateIdManager.getInstance().getIdFrom(state), bits);
        ChunkSection innerModelBlob = STORAGE_CONTENTS_BLOB_CACHE.get(cacheKey);
        if (innerModelBlob == null) {
            innerModelBlob = new ChunkSection(1);
            ChunkSectionUtils.fillFromBottom(innerModelBlob, state, bits);
            STORAGE_CONTENTS_BLOB_CACHE.put(cacheKey, innerModelBlob);
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.125, 0.125, 0.125);
        matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
        ChunkSection finalInnerModelBlob = innerModelBlob;
        RenderType.func_228661_n_().forEach(renderType -> {
            ChiseledBlockBakedModel innerModel = ChiseledBlockBakedModelManager.getInstance().get(MultiStateSnapshotUtils.createFromSection(finalInnerModelBlob), state, ChiselRenderType.fromLayer(renderType, te.getMyFluid() != null), new SingleBlockBlockReader(state, te.func_174877_v(), (IBlockReader)te.func_145831_w()), te.func_174877_v());
            if (!innerModel.isEmpty()) {
                float r = te.getMyFluid() == null ? 1.0f : (float)(te.getMyFluid().getAttributes().getColor() >> 16 & 0xFF) / 255.0f;
                float g = te.getMyFluid() == null ? 1.0f : (float)(te.getMyFluid().getAttributes().getColor() >> 8 & 0xFF) / 255.0f;
                float b = te.getMyFluid() == null ? 1.0f : (float)(te.getMyFluid().getAttributes().getColor() & 0xFF) / 255.0f;
                Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModel(matrixStackIn.func_227866_c_(), buffer.getBuffer(renderType), state, (IBakedModel)innerModel, r, g, b, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
            }
        });
        matrixStackIn.func_227865_b_();
    }

    private static final class CacheKey {
        private final int blockStateId;
        private final int bitCount;

        private CacheKey(int blockStateId, int bitCount) {
            this.blockStateId = blockStateId;
            this.bitCount = bitCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.blockStateId == cacheKey.blockStateId && this.bitCount == cacheKey.bitCount;
        }

        public int hashCode() {
            return Objects.hash(this.blockStateId, this.bitCount);
        }
    }
}

