/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.icon;

import mod.chiselsandbits.api.client.icon.IIconManager;
import mod.chiselsandbits.client.icon.IconSpriteUploader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class IconManager
implements IIconManager {
    private static final IconManager INSTANCE = new IconManager();
    private static final ResourceLocation ICON_SWAP = new ResourceLocation("chiselsandbits", "icons/swap");
    private static final ResourceLocation ICON_PLACE = new ResourceLocation("chiselsandbits", "icons/place");
    private static final ResourceLocation ICON_UNDO = new ResourceLocation("chiselsandbits", "icons/undo");
    private static final ResourceLocation ICON_REDO = new ResourceLocation("chiselsandbits", "icons/redo");
    private static final ResourceLocation ICON_TRASH = new ResourceLocation("chiselsandbits", "icons/trash");
    private static final ResourceLocation ICON_SORT = new ResourceLocation("chiselsandbits", "icons/sort");
    private static final ResourceLocation ICON_ROLL_X = new ResourceLocation("chiselsandbits", "icons/roll_x");
    private static final ResourceLocation ICON_ROLL_Z = new ResourceLocation("chiselsandbits", "icons/roll_z");
    private static final ResourceLocation ICON_WHITE = new ResourceLocation("chiselsandbits", "icons/white");
    private IconSpriteUploader iconSpriteUploader = null;

    public static IconManager getInstance() {
        return INSTANCE;
    }

    private IconManager() {
    }

    @SubscribeEvent
    public static void onBlockColorHandler(ColorHandlerEvent.Block event) {
        if (Minecraft.func_71410_x() != null) {
            IconManager.getInstance().initialize();
        }
    }

    private void initialize() {
        this.iconSpriteUploader = new IconSpriteUploader();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)resourceManager;
            reloadableResourceManager.func_219534_a((IFutureReloadListener)this.iconSpriteUploader);
        }
        this.registerIcon(ICON_SWAP);
        this.registerIcon(ICON_PLACE);
        this.registerIcon(ICON_UNDO);
        this.registerIcon(ICON_REDO);
        this.registerIcon(ICON_TRASH);
        this.registerIcon(ICON_SORT);
        this.registerIcon(ICON_ROLL_X);
        this.registerIcon(ICON_ROLL_Z);
        this.registerIcon(ICON_WHITE);
    }

    @Override
    public void registerIcon(ResourceLocation name) {
        if (this.iconSpriteUploader == null) {
            throw new IllegalStateException("Tried to register icon too early.");
        }
        this.iconSpriteUploader.registerTexture(name);
    }

    @Override
    public TextureAtlasSprite getIcon(ResourceLocation name) {
        if (this.iconSpriteUploader == null) {
            throw new IllegalStateException("Tried to get icon too early.");
        }
        return this.iconSpriteUploader.func_215282_a(name);
    }

    @Override
    public TextureAtlasSprite getSwapIcon() {
        return this.getIcon(ICON_SWAP);
    }

    @Override
    public TextureAtlasSprite getPlaceIcon() {
        return this.getIcon(ICON_PLACE);
    }

    @Override
    public TextureAtlasSprite getUndoIcon() {
        return this.getIcon(ICON_UNDO);
    }

    @Override
    public TextureAtlasSprite getRedoIcon() {
        return this.getIcon(ICON_REDO);
    }

    @Override
    public TextureAtlasSprite getTrashIcon() {
        return this.getIcon(ICON_TRASH);
    }

    @Override
    public TextureAtlasSprite getSortIcon() {
        return this.getIcon(ICON_SORT);
    }

    @Override
    public TextureAtlasSprite getRollXIcon() {
        return this.getIcon(ICON_ROLL_X);
    }

    @Override
    public TextureAtlasSprite getRollZIcon() {
        return this.getIcon(ICON_ROLL_Z);
    }

    @Override
    public TextureAtlasSprite getWhiteIcon() {
        return this.getIcon(ICON_WHITE);
    }

    @Override
    public void bindTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(IconSpriteUploader.TEXTURE_MAP_NAME);
    }
}

