/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModelManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ChiseledBlockBakedModelManager INSTANCE = new ChiseledBlockBakedModelManager();
    private final Cache<Key, ChiseledBlockBakedModel> cache;

    public static ChiseledBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    private ChiseledBlockBakedModelManager() {
        this.cache = CacheBuilder.newBuilder().maximumSize((Long)Configuration.getInstance().getClient().modelCacheSize.get() * (long)RenderType.func_228661_n_().size()).expireAfterAccess(1L, TimeUnit.HOURS).build();
    }

    /*
     * Loose catch block
     */
    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockState primaryState, ChiselRenderType renderType, @Nullable IBlockReader blockReader, @Nullable BlockPos position) {
        Throwable throwable = null;
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            EnumMap<Direction, BlockState> neighborhoodMap = new EnumMap<Direction, BlockState>(Direction.class);
            try (IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Key building");){
                if (blockReader != null && position != null) {
                    for (Direction value : Direction.values()) {
                        BlockPos offsetPos = position.func_177972_a(value);
                        neighborhoodMap.put(value, blockReader.func_180495_p(offsetPos));
                    }
                }
            }
            long primaryStateRenderSeed = primaryState.func_209533_a(position);
            Key key = new Key(accessor.createNewShapeIdentifier(), primaryState, renderType, neighborhoodMap, primaryStateRenderSeed);
            try {
                ChiseledBlockBakedModel chiseledBlockBakedModel = (ChiseledBlockBakedModel)this.cache.get((Object)key, () -> {
                    try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Cache mis");){
                        ChiseledBlockBakedModel chiseledBlockBakedModel = new ChiseledBlockBakedModel(primaryState, renderType, accessor, targetOffset -> {
                            if (blockReader == null || position == null) {
                                return Blocks.field_150350_a.func_176223_P();
                            }
                            Vector3d targetPositionVector = Vector3d.func_237491_b_((Vector3i)position).func_178787_e(targetOffset);
                            BlockPos targetPosition = new BlockPos(targetPositionVector);
                            TileEntity tileEntity = blockReader.func_175625_s(targetPosition);
                            if (tileEntity instanceof IMultiStateBlockEntity) {
                                IMultiStateBlockEntity blockEntity = (IMultiStateBlockEntity)tileEntity;
                                Vector3d inBlockOffset = targetPositionVector.func_178788_d(Vector3d.func_237491_b_((Vector3i)targetPosition));
                                Vector3d inBlockOffsetTarget = VectorUtils.makePositive(inBlockOffset);
                                return blockEntity.getInAreaTarget(inBlockOffsetTarget).map(IStateEntryInfo::getState).orElse(Blocks.field_150350_a.func_176223_P());
                            }
                            return blockReader.func_180495_p(targetPosition);
                        }, primaryStateRenderSeed);
                        return chiseledBlockBakedModel;
                    }
                });
                return chiseledBlockBakedModel;
            }
            catch (ExecutionException e) {
                ChiseledBlockBakedModel chiseledBlockBakedModel;
                block32: {
                    block33: {
                        LOGGER.error("Failed to calculate the chiseled block model. Calculation was interrupted.", (Throwable)e);
                        chiseledBlockBakedModel = ChiseledBlockBakedModel.EMPTY;
                        if (ignored1 == null) break block32;
                        if (throwable == null) break block33;
                        try {
                            ignored1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block32;
                    }
                    ignored1.close();
                }
                return chiseledBlockBakedModel;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public Optional<ChiseledBlockBakedModel> get(IMultiStateItemStack multiStateItemStack, ChiselRenderType renderType) {
        try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Item based chiseled block model");){
            Optional<ChiseledBlockBakedModel> optional = Optional.of(this.get(multiStateItemStack, multiStateItemStack.getStatistics().getPrimaryState(), renderType, null, BlockPos.field_177992_a));
            return optional;
        }
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final BlockState primaryState;
        private final ChiselRenderType renderType;
        private final EnumMap<Direction, BlockState> neighborhoodMap;
        private final long renderSeed;

        private Key(IAreaShapeIdentifier identifier, BlockState primaryState, ChiselRenderType renderType, EnumMap<Direction, BlockState> neighborhoodMap, long renderSeed) {
            this.identifier = identifier;
            this.primaryState = primaryState;
            this.renderType = renderType;
            this.neighborhoodMap = neighborhoodMap;
            this.renderSeed = renderSeed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.renderSeed != key.renderSeed) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.primaryState, key.primaryState)) {
                return false;
            }
            if (this.renderType != key.renderType) {
                return false;
            }
            return Objects.equals(this.neighborhoodMap, key.neighborhoodMap);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.primaryState != null ? this.primaryState.hashCode() : 0);
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.neighborhoodMap != null ? this.neighborhoodMap.hashCode() : 0);
            result = 31 * result + (int)(this.renderSeed ^ this.renderSeed >>> 32);
            return result;
        }
    }
}

