/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.base.BaseSmartModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.FluidRenderingManager;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class DataAwareChiseledBlockBakedModel
extends BaseSmartModel {
    private final ModelProperty<IBakedModel> MODEL_PROP = new ModelProperty();

    public boolean func_230044_c_() {
        return true;
    }

    @Override
    public IBakedModel handleBlockState(BlockState state, Random random, IModelData modelData) {
        if (!modelData.hasProperty(this.MODEL_PROP)) {
            return NullBakedModel.instance;
        }
        return (IBakedModel)modelData.getData(this.MODEL_PROP);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public IModelData getModelData(@NotNull IBlockDisplayReader world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        BaseBakedBlockModel baked;
        Throwable throwable;
        IProfilerSection ignored3;
        TileEntity tileEntity;
        IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Extract model data from data");
        Throwable throwable2 = null;
        if (world.func_175625_s(pos) == null) {
            ModelDataMap modelDataMap = new ModelDataMap.Builder().build();
            return modelDataMap;
        }
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            try (IProfilerSection ignored22 = ProfilingManager.getInstance().withSection("Unknown render layer model building");){
                IBakedModel[] models = new ChiseledBlockBakedModel[ChiselRenderType.values().length];
                int o = 0;
                TileEntity tileEntity2 = world.func_175625_s(pos);
                if (tileEntity2 instanceof IMultiStateBlockEntity) {
                    try (IProfilerSection ignored32 = ProfilingManager.getInstance().withSection("Individual render types building");){
                        for (ChiselRenderType chiselRenderType : ChiselRenderType.values()) {
                            try (IProfilerSection ignored4 = ProfilingManager.getInstance().withSection(chiselRenderType.name());){
                                ChiseledBlockBakedModel model = ChiseledBlockBakedModelManager.getInstance().get((IMultiStateBlockEntity)tileEntity2, ((IMultiStateBlockEntity)tileEntity2).getStatistics().getPrimaryState(), chiselRenderType, (IBlockReader)world, pos);
                                models[o++] = model;
                            }
                        }
                    }
                    ignored32 = ProfilingManager.getInstance().withSection("Combining model");
                    var14_32 = null;
                    try {
                        ModelDataMap modelDataMap = new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)new CombinedModel(models)).build();
                        return modelDataMap;
                    }
                    catch (Throwable throwable3) {
                        var14_32 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (ignored32 != null) {
                            if (var14_32 != null) {
                                try {
                                    ignored32.close();
                                }
                                catch (Throwable throwable4) {
                                    var14_32.addSuppressed(throwable4);
                                }
                            } else {
                                ignored32.close();
                            }
                        }
                    }
                }
                ModelDataMap ignored33 = new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)NullBakedModel.instance).build();
                return ignored33;
            }
        }
        IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Known render layer model building");
        {
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            Throwable throwable6 = null;
            try {
                tileEntity = world.func_175625_s(pos);
                if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                    ModelDataMap o = new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)NullBakedModel.instance).build();
                    return o;
                }
            }
            catch (Throwable throwable7) {}
            {
                throwable6 = throwable7;
                throw throwable7;
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        if (multiStateBlockEntity.getStatistics().getStateCounts().isEmpty()) return new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)NullBakedModel.instance).build();
        if (multiStateBlockEntity.getStatistics().getStateCounts().size() == 1 && multiStateBlockEntity.getStatistics().getStateCounts().containsKey(Blocks.field_150350_a.func_176223_P())) {
            return new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)NullBakedModel.instance).build();
        }
        if (RenderType.func_228661_n_().contains(layer) && FluidRenderingManager.getInstance().isFluidRenderType(layer)) {
            ignored3 = ProfilingManager.getInstance().withSection("Solid and fluid model building");
            throwable = null;
            try {
                ChiseledBlockBakedModel fluidModel;
                ChiseledBlockBakedModel solidModel;
                try (IProfilerSection ignored4 = ProfilingManager.getInstance().withSection("Solid");){
                    solidModel = ChiseledBlockBakedModelManager.getInstance().get((IMultiStateBlockEntity)tileEntity, ((IMultiStateBlockEntity)tileEntity).getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(layer, false), (IBlockReader)world, pos);
                }
                try (IProfilerSection ignored4 = ProfilingManager.getInstance().withSection("Fluid");){
                    fluidModel = ChiseledBlockBakedModelManager.getInstance().get((IMultiStateBlockEntity)tileEntity, ((IMultiStateBlockEntity)tileEntity).getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(layer, true), (IBlockReader)world, pos);
                }
                ignored4 = ProfilingManager.getInstance().withSection("Model combining");
                var18_57 = null;
                try {
                    baked = solidModel.isEmpty() ? fluidModel : (fluidModel.isEmpty() ? solidModel : new CombinedModel(solidModel, fluidModel));
                    return new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)baked).build();
                }
                catch (Throwable throwable8) {
                    var18_57 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (ignored4 != null) {
                        if (var18_57 != null) {
                            try {
                                ignored4.close();
                            }
                            catch (Throwable throwable9) {
                                var18_57.addSuppressed(throwable9);
                            }
                        } else {
                            ignored4.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (ignored3 != null) {
                    if (throwable != null) {
                        try {
                            ignored3.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        ignored3.close();
                    }
                }
            }
        }
        ignored3 = ProfilingManager.getInstance().withSection("Solid or fluid model building");
        throwable = null;
        try {
            baked = ChiseledBlockBakedModelManager.getInstance().get((IMultiStateBlockEntity)tileEntity, ((IMultiStateBlockEntity)tileEntity).getStatistics().getPrimaryState(), ChiselRenderType.fromLayer(layer, false), (IBlockReader)world, pos);
            return new ModelDataMap.Builder().withInitial(this.MODEL_PROP, (Object)baked).build();
        }
        catch (Throwable throwable12) {
            throwable = throwable12;
            throw throwable12;
        }
        finally {
            if (ignored1 != null) {
                if (throwable2 != null) {
                    try {
                        ignored1.close();
                    }
                    catch (Throwable throwable13) {
                        throwable2.addSuppressed(throwable13);
                    }
                } else {
                    ignored1.close();
                }
            }
        }
    }

    @Override
    public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, World world, LivingEntity entity) {
        IBakedModel[] typedModels;
        Item item = stack.func_77973_b();
        if (!(item instanceof IMultiStateItem)) {
            return NullBakedModel.instance;
        }
        IMultiStateItem multiStateItem = (IMultiStateItem)item;
        IMultiStateItemStack multiStateItemStack = multiStateItem.createItemStack(stack);
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Building individual render type models");){
            typedModels = (IBakedModel[])Arrays.stream(VoxelType.values()).map(ChiselRenderType::getRenderTypes).filter(types -> !types.isEmpty()).map(types -> {
                IBakedModel[] models = (IBakedModel[])types.stream().map(type -> ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, (ChiselRenderType)((Object)((Object)type)))).filter(Optional::isPresent).map(Optional::get).filter(model -> !model.isEmpty()).toArray(IBakedModel[]::new);
                if (models.length == 0) {
                    return ChiseledBlockBakedModel.EMPTY;
                }
                return new CombinedModel(models);
            }).toArray(IBakedModel[]::new);
        }
        if (typedModels.length == 0) {
            return ChiseledBlockBakedModel.EMPTY;
        }
        ignored1 = ProfilingManager.getInstance().withSection("Combining model data");
        var10_9 = null;
        try {
            CombinedModel combinedModel = new CombinedModel(typedModels);
            return combinedModel;
        }
        catch (Throwable throwable) {
            var10_9 = throwable;
            throw throwable;
        }
        finally {
            if (ignored1 != null) {
                if (var10_9 != null) {
                    try {
                        ignored1.close();
                    }
                    catch (Throwable throwable) {
                        var10_9.addSuppressed(throwable);
                    }
                } else {
                    ignored1.close();
                }
            }
        }
    }
}

