/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.util.DeprecationHelper;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.ModelVertexRange;
import mod.chiselsandbits.client.model.baked.simple.SimpleGeneratedModel;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FaceManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    private static final FaceManager INSTANCE = new FaceManager();
    private final Cache<Key, ModelQuadLayer[]> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final Cache<BlockState, Integer> colorCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    private FaceManager() {
    }

    public static FaceManager getInstance() {
        return INSTANCE;
    }

    public ModelQuadLayer[] getCachedFace(BlockState state, Direction face, RenderType layer, long primaryStateRenderSeed) {
        if (layer == null) {
            return null;
        }
        Key key = new Key(state, layer, face, primaryStateRenderSeed);
        try {
            return (ModelQuadLayer[])this.cache.get((Object)key, () -> {
                RenderType original = MinecraftForgeClient.getRenderLayer();
                try {
                    ForgeHooksClient.setRenderLayer((RenderType)layer);
                    ModelQuadLayer[] modelQuadLayerArray = this.buildFaceQuadLayers(state, face, primaryStateRenderSeed);
                    return modelQuadLayerArray;
                }
                finally {
                    ForgeHooksClient.setRenderLayer((RenderType)original);
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to determine face cache entry.", (Throwable)e);
            return new ModelQuadLayer[0];
        }
    }

    private ModelQuadLayer[] buildFaceQuadLayers(BlockState state, Direction face, long primaryStateRenderSeed) {
        IBakedModel model = FaceManager.solveModel(state, Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state), primaryStateRenderSeed);
        int lv = (Boolean)Configuration.getInstance().getClient().useGetLightValue.get() != false ? DeprecationHelper.getLightValue(state) : 0;
        Fluid fluid = state.func_204520_s().func_206886_c();
        if (fluid != Fluids.field_204541_a) {
            ModelQuadLayer[] mp = new ModelQuadLayer[]{new ModelQuadLayer()};
            mp[0].setColor(fluid.getAttributes().getColor());
            mp[0].setLight(lv);
            float V = 0.5f;
            float Uf = 1.0f;
            float U = 0.5f;
            float Vf = 1.0f;
            if (face.func_176740_k() == Direction.Axis.Y) {
                mp[0].setSprite((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getStillTexture()));
                mp[0].setUvs(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
            } else if (face.func_176740_k() == Direction.Axis.X) {
                mp[0].setSprite((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getFlowingTexture()));
                mp[0].setUvs(new float[]{0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f});
            } else {
                mp[0].setSprite((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getFlowingTexture()));
                mp[0].setUvs(new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f});
            }
            mp[0].setTint(0);
            return mp;
        }
        ArrayList layers = Lists.newArrayList();
        int color = this.getColorFor(state);
        if (model != null) {
            List<BakedQuad> quads = FaceManager.getModelQuads(model, state, face, primaryStateRenderSeed);
            FaceManager.processFaces(layers, face, quads);
        }
        ModelQuadLayer[] quadLayers = new ModelQuadLayer[layers.size()];
        for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
            quadLayers[layerIndex] = ((ModelQuadLayer.ModelQuadLayerBuilder)layers.get(layerIndex)).build(state, color, lv);
        }
        return quadLayers;
    }

    private static void processFaces(List<ModelQuadLayer.ModelQuadLayerBuilder> layers, Direction face, List<BakedQuad> quads) {
        for (BakedQuad q : quads) {
            if (q.func_178210_d() != face) {
                return;
            }
            try {
                TextureAtlasSprite sprite = FaceManager.findQuadTexture(q);
                ModelQuadLayer.ModelQuadLayerBuilder b = null;
                for (ModelQuadLayer.ModelQuadLayerBuilder lx : layers) {
                    if (lx.cache.getSprite() != sprite) continue;
                    b = lx;
                    break;
                }
                if (b == null) {
                    int uCoord = 0;
                    int vCoord = 2;
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            uCoord = 0;
                            vCoord = 1;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            uCoord = 1;
                            vCoord = 2;
                            break;
                        }
                    }
                    b = new ModelQuadLayer.ModelQuadLayerBuilder(sprite, uCoord, vCoord);
                    b.cache.setTint(q.func_178211_c());
                    layers.add(b);
                }
                q.pipe((IVertexConsumer)b.uvr);
                if (!((Boolean)Configuration.getInstance().getClient().enableFaceLightmapExtraction.get()).booleanValue()) continue;
                b.lv.setVertexFormat(DefaultVertexFormats.field_176600_a);
                q.pipe((IVertexConsumer)b.lv);
            }
            catch (Exception exception) {}
        }
    }

    private static IBakedModel solveModel(BlockState state, IBakedModel originalModel, long primaryStateRenderSeed) {
        ItemStack is;
        boolean hasFaces;
        try {
            hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed);
            for (Direction f : Direction.values()) {
                hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && !(is = ItemStackUtils.getItemStackFromBlockState(state)).func_190926_b()) {
            IBakedModel itemModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(is, (World)Minecraft.func_71410_x().field_71441_e, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
            try {
                hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed);
                for (Direction f : Direction.values()) {
                    hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed);
                }
            }
            catch (Exception e) {
                hasFaces = false;
            }
            if (hasFaces) {
                return itemModel;
            }
            return new SimpleGeneratedModel(FaceManager.findTexture(state, originalModel, Direction.UP, primaryStateRenderSeed));
        }
        return originalModel;
    }

    private static boolean hasFaces(IBakedModel model, BlockState state, Direction f, long primaryStateRenderSeed) {
        List<BakedQuad> l = FaceManager.getModelQuads(model, state, f, primaryStateRenderSeed);
        if (l == null || l.isEmpty()) {
            return false;
        }
        TextureAtlasSprite texture = null;
        try {
            texture = FaceManager.findTexture(null, l, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelVertexRange mvr = new ModelVertexRange();
        for (BakedQuad q : l) {
            q.pipe((IVertexConsumer)mvr);
        }
        return mvr.getLargestRange() > 0.0f && !FaceManager.isMissingTexture(texture);
    }

    public static TextureAtlasSprite findTexture(BlockState state, IBakedModel model, Direction myFace, long primaryStateRenderSeed) {
        TextureAtlasSprite texture = null;
        if (model != null) {
            try {
                texture = FaceManager.findTexture(null, FaceManager.getModelQuads(model, state, myFace, primaryStateRenderSeed), myFace);
                if (texture == null) {
                    for (Direction side : Direction.values()) {
                        texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, side, primaryStateRenderSeed), side);
                    }
                    texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, null, primaryStateRenderSeed), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                if (model != null) {
                    texture = model.func_177554_e();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("missingno"));
        }
        return texture;
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads, Direction myFace) throws IllegalArgumentException, NullPointerException {
        for (BakedQuad q : faceQuads) {
            if (q.func_178210_d() != myFace) continue;
            texture = FaceManager.findQuadTexture(q);
        }
        return texture;
    }

    private static TextureAtlasSprite findQuadTexture(BakedQuad q) throws IllegalArgumentException, NullPointerException {
        if (q.field_187509_d == null) {
            return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
        }
        return q.field_187509_d;
    }

    private static boolean isMissingTexture(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return true;
        }
        return sprite.func_195668_m().equals((Object)MissingTextureSprite.func_195675_b());
    }

    private static List<BakedQuad> getModelQuads(IBakedModel model, BlockState state, Direction f, long primaryStateRenderSeed) {
        try {
            RANDOM.setSeed(primaryStateRenderSeed);
            return model.func_200117_a(state, f, RANDOM);
        }
        catch (Throwable throwable) {
            try {
                return model.func_200117_a(null, f, RANDOM);
            }
            catch (Throwable throwable2) {
                IBakedModel secondModel;
                ItemStack is = ItemStackUtils.getItemStackFromBlockState(state);
                if (!is.func_190926_b() && (secondModel = FaceManager.getOverrides(model).func_239290_a_(model, is, Minecraft.func_71410_x().field_71441_e, (LivingEntity)Minecraft.func_71410_x().field_71439_g)) != null) {
                    try {
                        return secondModel.func_200117_a(null, f, RANDOM);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static ItemOverrideList getOverrides(IBakedModel model) {
        if (model != null) {
            return model.func_188617_f();
        }
        return ItemOverrideList.field_188022_a;
    }

    private int getColorFor(BlockState state) {
        try {
            return (Integer)this.colorCache.get((Object)state, () -> {
                ItemStack target;
                Fluid fluid = state.func_204520_s().func_206886_c();
                int out = fluid != Fluids.field_204541_a ? fluid.getAttributes().getColor() : ((target = ItemStackUtils.getItemStackFromBlockState(state)).func_190926_b() ? 0xFFFFFF : Minecraft.func_71410_x().getItemColors().func_186728_a(target, 0));
                return out;
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to determine the color of a blockstate.", (Throwable)e);
            return 0;
        }
    }

    private static final class Key {
        private final BlockState blockState;
        private final RenderType renderType;
        private final Direction direction;
        private final long primaryStateSeed;

        private Key(BlockState blockState, RenderType renderType, Direction direction, long primaryStateSeed) {
            this.blockState = blockState;
            this.renderType = renderType;
            this.direction = direction;
            this.primaryStateSeed = primaryStateSeed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.primaryStateSeed != key.primaryStateSeed) {
                return false;
            }
            if (!Objects.equals(this.blockState, key.blockState)) {
                return false;
            }
            if (!Objects.equals(this.renderType, key.renderType)) {
                return false;
            }
            return this.direction == key.direction;
        }

        public int hashCode() {
            int result = this.blockState != null ? this.blockState.hashCode() : 0;
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
            result = 31 * result + (int)(this.primaryStateSeed ^ this.primaryStateSeed >>> 32);
            return result;
        }
    }
}

