/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.stream.Stream;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import mod.chiselsandbits.api.profiling.IProfilingManager;
import mod.chiselsandbits.api.util.BlockStateUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.CommandUtils;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandManager {
    private static final CommandManager INSTANCE = new CommandManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleCommandExceptionType GIVE_NOT_CHISELABLE_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent(LocalStrings.CommandGiveErrorBlockStateNotChiselable.toString()));

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        return INSTANCE;
    }

    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"candb").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"fill").then(Commands.func_197056_a((String)"start", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"end", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"state", (ArgumentType)BlockStateArgument.func_197239_a()).executes(this::runFillCommand))).then(Commands.func_197057_a((String)"random").executes(this::runFillCommand)))))).then(Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"start", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"end", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(this::runClearCommand))))).then(Commands.func_197057_a((String)"stats").then(Commands.func_197056_a((String)"start", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).then(Commands.func_197056_a((String)"end", (ArgumentType)Vec3Argument.func_197303_a((boolean)false)).executes(this::runStatsCommand))))).then(Commands.func_197057_a((String)"give").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"state", (ArgumentType)BlockStateArgument.func_197239_a()).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4096)).executes(this::runGiveCommand))).executes(this::runGiveCommand))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"profiling").then(Commands.func_197057_a((String)"start").executes(this::startProfiling))).then(Commands.func_197057_a((String)"stop").executes(this::stopProfiling))));
    }

    private int runFillCommand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Vector3d start = Vec3Argument.func_197300_a(context, (String)"start");
        Vector3d end = Vec3Argument.func_197300_a(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((IWorld)((CommandSource)context.getSource()).func_197023_e(), start, end);
        if (CommandUtils.hasArgument(context, "state")) {
            BlockState state = BlockStateArgument.func_197238_a(context, (String)"state").func_197231_a();
            try (IBatchMutation ignored = mutator.batch();){
                ((Stream)mutator.mutableStream().parallel()).forEach(entry -> {
                    try {
                        entry.clear();
                        entry.setState(state);
                    }
                    catch (SpaceOccupiedException e) {
                        LOGGER.warn("Executing the command: " + context.getInput() + " failed to clear and set the state for entry: " + entry);
                    }
                });
            }
        }
        try (IBatchMutation ignored = mutator.batch();){
            mutator.mutableStream().forEach(entry -> {
                try {
                    entry.clear();
                    entry.setState(BlockStateUtils.getRandomSupportedDefaultState(((CommandSource)context.getSource()).func_197023_e().func_201674_k()));
                }
                catch (SpaceOccupiedException e) {
                    LOGGER.warn("Executing the command: " + context.getInput() + " failed to clear and set the state for entry: " + entry);
                }
            });
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(LocalStrings.CommandFillCompleted.toString()), true);
        return 0;
    }

    private int runClearCommand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Vector3d start = Vec3Argument.func_197300_a(context, (String)"start");
        Vector3d end = Vec3Argument.func_197300_a(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((IWorld)((CommandSource)context.getSource()).func_197023_e(), start, end);
        try (IBatchMutation ignored = mutator.batch();){
            mutator.mutableStream().forEach(IMutableStateEntryInfo::clear);
        }
        return 0;
    }

    private int runStatsCommand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Vector3d start = Vec3Argument.func_197300_a(context, (String)"start");
        Vector3d end = Vec3Argument.func_197300_a(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((IWorld)((CommandSource)context.getSource()).func_197023_e(), start, end);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Collected the following statistics for the requested area:"), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("----------------------------------------------------------"), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("BlockStates:"), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("############"), true);
        mutator.createSnapshot().getStatics().getStateCounts().forEach((state, count) -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" > ").func_230529_a_((ITextComponent)state.func_177230_c().func_235333_g_()).func_230529_a_((ITextComponent)new StringTextComponent(": " + count)), true));
        return 0;
    }

    private int runGiveCommand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(context, (String)"target");
        BlockState state = BlockStateArgument.func_197238_a(context, (String)"state").func_197231_a();
        if (!IEligibilityManager.getInstance().canBeChiseled(state)) {
            throw GIVE_NOT_CHISELABLE_EXCEPTION.create();
        }
        int count = CommandUtils.hasArgument(context, "count") ? IntegerArgumentType.getInteger(context, (String)"count") : 4096;
        IBitInventory inventory = IBitInventoryManager.getInstance().create((PlayerEntity)target);
        int insertionCount = Math.min(inventory.getMaxInsertAmount(state), count);
        inventory.insert(state, insertionCount);
        return 0;
    }

    private int startProfiling(CommandContext<CommandSource> context) throws CommandSyntaxException {
        if (ProfilingManager.getInstance().hasProfiler()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Already profiling!"));
            return 1;
        }
        ProfilingManager.getInstance().setProfiler(IProfilingManager.getInstance().startProfiling());
        return 0;
    }

    private int stopProfiling(CommandContext<CommandSource> context) throws CommandSyntaxException {
        if (!ProfilingManager.getInstance().hasProfiler()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Not yet profiling!"));
            return 1;
        }
        IProfilerResult result = IProfilingManager.getInstance().endProfiling(ProfilingManager.getInstance().getProfiler());
        result.writeAsResponse(line -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(line), true));
        ProfilingManager.getInstance().setProfiler(null);
        return 0;
    }
}

