/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.inventory.bit.SlottedBitInventory;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class SlottedBitInventoryItemStack
extends SlottedBitInventory
implements IBitInventoryItemStack {
    private final Function<CompoundNBT, ItemStack> saveBuilder;

    public SlottedBitInventoryItemStack(int size, Function<CompoundNBT, ItemStack> saveBuilder) {
        super(size);
        this.saveBuilder = saveBuilder;
    }

    @Override
    public ItemStack toItemStack() {
        CompoundNBT compoundNBT = this.serializeNBT();
        return this.saveBuilder.apply(compoundNBT);
    }

    @Override
    public List<ITextComponent> listContents() {
        return this.getContents().stream().sorted(Comparator.comparingInt(SlottedBitInventory.BitSlot::getCount).reversed()).map(slot -> new TranslationTextComponent("chiselsandbits.bitbag.contents.enum.entry", new Object[]{slot.getCount(), slot.getState().func_177230_c().func_235333_g_()})).collect(Collectors.toList());
    }

    @Override
    public double getFilledRatio() {
        return (double)this.slotMap.keySet().size() / (double)this.size;
    }

    @Override
    public void clear(BlockState state) {
        Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.slotMap);
        this.slotMap.clear();
        int slotIndex = 0;
        for (SlottedBitInventory.BitSlot bitSlot : slots.values()) {
            if (bitSlot.getState() == state) continue;
            this.slotMap.put(slotIndex, (Object)bitSlot);
            ++slotIndex;
        }
    }

    @Override
    public void sort() {
        HashMap contentMap = Maps.newHashMap();
        this.slotMap.values().forEach(bitSlot -> {
            contentMap.putIfAbsent(bitSlot.getState(), 0);
            contentMap.compute(bitSlot.getState(), (s, c) -> (c == null ? 0 : c) + bitSlot.getCount());
        });
        this.slotMap.clear();
        ArrayList toSort = new ArrayList(contentMap.entrySet());
        toSort.sort(Map.Entry.comparingByValue().reversed());
        int slotIndex = 0;
        for (Map.Entry entry : toSort) {
            int count = (Integer)entry.getValue();
            if (count == 0) continue;
            while (count > (Integer)Configuration.getInstance().getServer().bagStackSize.get() && count > 0) {
                this.slotMap.put(slotIndex, (Object)new SlottedBitInventory.BitSlot((BlockState)entry.getKey(), (Integer)Configuration.getInstance().getServer().bagStackSize.get()));
                ++slotIndex;
                count -= ((Integer)Configuration.getInstance().getServer().bagStackSize.get()).intValue();
            }
            if (count <= 0) continue;
            this.slotMap.put(slotIndex, (Object)new SlottedBitInventory.BitSlot((BlockState)entry.getKey(), count));
            ++slotIndex;
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    @NotNull
    public ItemStack func_70301_a(int index) {
        return super.getStackInSlot(index);
    }

    @NotNull
    public ItemStack func_70298_a(int index, int count) {
        if (!this.slotMap.containsKey(index)) {
            return ItemStack.field_190927_a;
        }
        SlottedBitInventory.BitSlot bitSlot = (SlottedBitInventory.BitSlot)this.slotMap.get(index);
        int containedCount = bitSlot.getCount();
        bitSlot.setCount(containedCount - count);
        if (bitSlot.getCount() <= 0) {
            this.slotMap.remove(index);
        }
        return IBitItemManager.getInstance().create(bitSlot.getState(), Math.min(containedCount, count));
    }

    @NotNull
    public ItemStack func_70304_b(int index) {
        return this.func_70298_a(index, Integer.MAX_VALUE);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack.func_190926_b()) {
            this.slotMap.remove(index);
            return;
        }
        if (!(stack.func_77973_b() instanceof IBitItem)) {
            return;
        }
        IBitItem bitItem = (IBitItem)stack.func_77973_b();
        BlockState state = bitItem.getBitState(stack);
        SlottedBitInventory.BitSlot bitSlot = (SlottedBitInventory.BitSlot)this.slotMap.getOrDefault(index, (Object)new SlottedBitInventory.BitSlot());
        bitSlot.setState(state);
        bitSlot.setCount(stack.func_190916_E());
        this.slotMap.put(index, (Object)bitSlot);
    }

    public void func_70296_d() {
        this.onChange();
    }

    public boolean func_70300_a(@NotNull PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.slotMap.clear();
        this.onChange();
    }

    @Override
    protected void onChange() {
        super.onChange();
        this.toItemStack();
    }

    @Override
    protected int getMaxBitsForSlot() {
        return (Integer)Configuration.getInstance().getServer().bagStackSize.get();
    }

    public int func_70297_j_() {
        return this.getMaxBitsForSlot();
    }

    public boolean func_191420_l() {
        return super.isEmpty();
    }
}

