/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.inventory.bit.SlottedBitInventoryItemStack;
import mod.chiselsandbits.network.packets.OpenBagGuiPacket;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.SimpleInstanceCache;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitBagItem
extends Item
implements IBitInventoryItem {
    private static final int BAG_STORAGE_SLOTS = 63;
    SimpleInstanceCache<ItemStack, List<ITextComponent>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public BitBagItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @NotNull
    public ITextComponent func_200295_i(@NotNull ItemStack stack) {
        DyeColor color = BitBagItem.getDyedColor(stack);
        ITextComponent parent = super.func_200295_i(stack);
        if (parent instanceof IFormattableTextComponent && color != null) {
            return ((IFormattableTextComponent)parent).func_240702_b_(" - ").func_230529_a_((ITextComponent)new TranslationTextComponent("chiselsandbits.color." + color.func_176762_d()));
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        List<ITextComponent> details;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Configuration.getInstance().getCommon().helpText(LocalStrings.HelpBitBag, tooltip, new String[0]);
        if (this.tooltipCache.needsUpdate(stack)) {
            IBitInventoryItemStack inventoryItemStack = this.create(stack);
            this.tooltipCache.updateCachedValue(inventoryItemStack.listContents());
        }
        if ((details = this.tooltipCache.getCached()).size() <= 2 || Minecraft.func_71410_x().func_228018_at_() != null && Screen.func_231173_s_()) {
            tooltip.addAll(details);
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(LocalStrings.ShiftDetails.getLocal()));
        }
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @NotNull Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new OpenBagGuiPacket());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public IBitInventoryItemStack create(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return new SlottedBitInventoryItemStack(0, nbt -> ItemStack.field_190927_a);
        }
        SlottedBitInventoryItemStack inventoryItemStack = new SlottedBitInventoryItemStack(63, nbt -> {
            stack.func_196082_o().func_218657_a("Inventory", (INBT)nbt);
            return stack;
        });
        if (!stack.func_196082_o().func_74764_b("Inventory") && stack.func_196082_o().func_74764_b("contents")) {
            int[] legacyContentData = stack.func_196082_o().func_74759_k("contents");
            if (legacyContentData.length != 126) {
                int[] tmp = legacyContentData;
                legacyContentData = new int[126];
                System.arraycopy(legacyContentData, 0, tmp, 0, Math.min(126, tmp.length));
            }
            for (int i = 0; i < 63; ++i) {
                int count = legacyContentData[2 * i + 1];
                int id = legacyContentData[2 * i];
                BlockState blockState = IBlockStateIdManager.getInstance().getBlockStateFrom(id);
                ItemStack bitStack = IBitItemManager.getInstance().create(blockState, count);
                inventoryItemStack.func_70299_a(i, bitStack);
            }
            stack.func_196082_o().func_82580_o("contents");
        }
        inventoryItemStack.deserializeNBT(stack.func_190925_c("Inventory"));
        return inventoryItemStack;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IBitInventoryItem)) {
            return false;
        }
        IBitInventoryItem item = (IBitInventoryItem)stack.func_77973_b();
        IBitInventoryItemStack inventoryItemStack = item.create(stack);
        return !inventoryItemStack.func_191420_l();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IBitInventoryItem)) {
            return 0.0;
        }
        IBitInventoryItem item = (IBitInventoryItem)stack.func_77973_b();
        IBitInventoryItemStack inventoryItemStack = item.create(stack);
        double filledRatio = inventoryItemStack.getFilledRatio();
        return Math.min(1.0, Math.max(0.0, (Boolean)Configuration.getInstance().getClient().invertBitBagFullness.get() != false ? filledRatio : 1.0 - filledRatio));
    }

    public void func_150895_a(@NotNull ItemGroup group, @NotNull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (this == ModItems.BIT_BAG_DEFAULT.get()) {
                items.add((Object)new ItemStack((IItemProvider)this));
            } else {
                for (DyeColor color : DyeColor.values()) {
                    items.add((Object)BitBagItem.dyeBag(new ItemStack((IItemProvider)this), color));
                }
            }
        }
    }

    public static ItemStack dyeBag(ItemStack bag, DyeColor color) {
        ItemStack copy = bag.func_77946_l();
        if (!copy.func_77942_o()) {
            copy.func_77982_d(new CompoundNBT());
        }
        if (color == null && bag.func_77973_b() == ModItems.ITEM_BIT_BAG_DYED.get()) {
            ItemStack unColoredStack = new ItemStack((IItemProvider)ModItems.BIT_BAG_DEFAULT.get());
            unColoredStack.func_77982_d(copy.func_77978_p());
            unColoredStack.func_196082_o().func_82580_o("color");
            return unColoredStack;
        }
        if (color != null) {
            ItemStack coloredStack = copy;
            if (coloredStack.func_77973_b() == ModItems.BIT_BAG_DEFAULT.get()) {
                coloredStack = new ItemStack((IItemProvider)ModItems.ITEM_BIT_BAG_DYED.get());
                coloredStack.func_77982_d(copy.func_77978_p());
            }
            coloredStack.func_196082_o().func_74778_a("color", color.func_176762_d());
            return coloredStack;
        }
        return copy;
    }

    public static DyeColor getDyedColor(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.ITEM_BIT_BAG_DYED.get()) {
            return null;
        }
        if (stack.func_196082_o().func_74764_b("color")) {
            String name = stack.func_196082_o().func_74779_i("color");
            for (DyeColor color : DyeColor.values()) {
                if (!name.equals(color.func_176610_l())) continue;
                return color;
            }
        }
        return null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

