/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.ILocalChiselingContextCache;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.chiseling.ChiselingManager;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiselItem
extends ToolItem
implements IChiselItem {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Predicate<IStateEntryInfo> DEFAULT_CONTEXT_PREDICATE = new Predicate<IStateEntryInfo>(){

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            return !iStateEntryInfo.getState().func_196958_f();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };

    public ChiselItem(IItemTier tier, Item.Properties builderIn) {
        super(0.1f, -2.8f, tier, ModBlocks.MATERIAL_TO_BLOCK_CONVERSIONS.values().stream().map(RegistryObject::get).collect(Collectors.toSet()), builderIn);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        IChiselMode mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((ITextComponent)TranslationUtils.build("chiselmode.mode_grouped", ((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((ITextComponent)TranslationUtils.build("chiselmode.mode", mode.getDisplayName()));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @NotNull
    public IChiselMode getMode(ItemStack stack) {
        CompoundNBT stackNbt = stack.func_196082_o();
        if (stackNbt.func_74764_b("chiselMode")) {
            String chiselModeName = stackNbt.func_74779_i("chiselMode");
            try {
                IChiselMode registryMode = (IChiselMode)IChiselMode.getRegistry().getValue(new ResourceLocation(chiselModeName));
                if (registryMode == null) {
                    return IChiselMode.getDefaultMode();
                }
                return registryMode;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid chisel mode: %s", chiselModeName));
                this.setMode(stack, IChiselMode.getDefaultMode());
            }
        }
        return IChiselMode.getDefaultMode();
    }

    @Override
    public void setMode(ItemStack stack, IChiselMode mode) {
        stack.func_196082_o().func_74778_a("chiselMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IChiselMode> getPossibleModes() {
        return IChiselMode.getRegistry().getValues().stream().sorted(Comparator.comparing(arg_0 -> ((ForgeRegistry)((ForgeRegistry)IChiselMode.getRegistry())).getID(arg_0))).collect(Collectors.toList());
    }

    @Override
    public ClickProcessingState handleLeftClickProcessing(PlayerEntity playerEntity, Hand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != this) {
            return currentState;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.func_77973_b();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        IChiselingContext context = IChiselingManager.getInstance().getOrCreateContext(playerEntity, chiselMode, ChiselingOperation.CHISELING, false, itemStack);
        ClickProcessingState resultState = chiselMode.onLeftClickBy(playerEntity, context);
        if (context.isComplete()) {
            playerEntity.func_184811_cZ().func_185145_a((Item)this, 3);
        }
        return resultState;
    }

    @Override
    public boolean canUse(PlayerEntity playerEntity) {
        return ChiselingManager.getInstance().canChisel(playerEntity);
    }

    @Override
    public boolean shouldDrawDefaultHighlight(@NotNull PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != this) {
            return true;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.func_77973_b();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext context = potentiallyExistingContext.get();
            if (context.getMutator().isPresent()) {
                return false;
            }
            IChiselingContext currentContextSnapshot = context.createSnapshot();
            chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            return !currentContextSnapshot.getMutator().isPresent();
        }
        Optional<IChiselingContext> localCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (localCachedContext.isPresent() && localCachedContext.get().getMode().isStillValid(playerEntity, localCachedContext.get(), ChiselingOperation.CHISELING)) {
            IChiselingContext context = localCachedContext.get();
            if (context.getMode() == chiselMode && context.getMutator().isPresent()) {
                return false;
            }
            return !context.getMutator().isPresent();
        }
        IChiselingContext context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, context);
        ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, context);
        return !context.getMutator().isPresent();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHighlight(PlayerEntity playerEntity, WorldRenderer worldRenderer, MatrixStack matrixStack, float partialTicks, Matrix4f projectionMatrix, long finishTimeNano) {
        IChiselingContext context;
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != this) {
            return;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.func_77973_b();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        Optional<IChiselingContext> potentiallyCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            context = potentiallyExistingContext.get();
            chiselMode.onLeftClickBy(playerEntity, context);
        } else if (potentiallyCachedContext.isPresent() && potentiallyCachedContext.get().getMode() == chiselMode && potentiallyCachedContext.get().getModeOfOperandus() == ChiselingOperation.CHISELING && chiselMode.isStillValid(playerEntity, potentiallyCachedContext.get(), ChiselingOperation.CHISELING)) {
            context = potentiallyCachedContext.get();
        } else {
            context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
            chiselMode.onLeftClickBy(playerEntity, context);
        }
        if (!context.getMutator().isPresent()) {
            ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            return;
        }
        ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, context);
        Vector3d vector3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double xView = vector3d.func_82615_a();
        double yView = vector3d.func_82617_b();
        double zView = vector3d.func_82616_c();
        BlockPos inWorldStartPos = new BlockPos(context.getMutator().get().getInWorldStartPoint());
        VoxelShape boundingShape = VoxelShapeManager.getInstance().get(context.getMutator().get(), areaAccessor -> {
            Predicate<IStateEntryInfo> contextPredicate = context.getStateFilter().map(factory -> (Predicate)factory.apply(areaAccessor)).orElse(DEFAULT_CONTEXT_PREDICATE);
            return new InternalContextFilter(contextPredicate);
        }, false);
        RenderSystem.disableDepthTest();
        WorldRenderer.func_228445_b_((MatrixStack)matrixStack, (IVertexBuilder)Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(ModRenderTypes.MEASUREMENT_LINES.get()), (VoxelShape)boundingShape, (double)((double)inWorldStartPos.func_177958_n() - xView), (double)((double)inWorldStartPos.func_177956_o() - yView), (double)((double)inWorldStartPos.func_177952_p() - zView), (float)0.95f, (float)0.0f, (float)0.0f, (float)0.65f);
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(ModRenderTypes.MEASUREMENT_LINES.get());
        RenderSystem.enableDepthTest();
    }

    @Override
    public boolean isDamageableDuringChiseling() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        IItemTier tier = this.func_200891_e();
        return tier.func_200926_a() * StateEntrySize.current().getBitsPerBlock();
    }

    private static final class InternalContextFilter
    implements Predicate<IStateEntryInfo> {
        private final Predicate<IStateEntryInfo> placingContextPredicate;

        private InternalContextFilter(Predicate<IStateEntryInfo> placingContextPredicate) {
            this.placingContextPredicate = placingContextPredicate;
        }

        @Override
        public boolean test(IStateEntryInfo s) {
            return (s.getState().func_196958_f() || IEligibilityManager.getInstance().canBeChiseled(s.getState())) && this.placingContextPredicate.test(s);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InternalContextFilter)) {
                return false;
            }
            InternalContextFilter that = (InternalContextFilter)o;
            return Objects.equals(this.placingContextPredicate, that.placingContextPredicate);
        }

        public int hashCode() {
            return this.placingContextPredicate != null ? this.placingContextPredicate.hashCode() : 0;
        }
    }
}

