/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.measuring.IMeasuringTapeItem;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.keys.KeyBindingManager;
import mod.chiselsandbits.measures.MeasuringManager;
import mod.chiselsandbits.network.packets.MeasurementsResetPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasuringTapeItem
extends Item
implements IMeasuringTapeItem {
    public MeasuringTapeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public MeasuringMode getMode(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b("mode")) {
            return MeasuringMode.WHITE_BIT;
        }
        return MeasuringMode.valueOf(stack.func_196082_o().func_74779_i("mode"));
    }

    @Override
    public void setMode(ItemStack stack, MeasuringMode mode) {
        stack.func_196082_o().func_74778_a("mode", mode.toString());
    }

    @Override
    @NotNull
    public Collection<MeasuringMode> getPossibleModes() {
        return Lists.newArrayList((Object[])MeasuringMode.values());
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(PlayerEntity playerEntity, Hand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        ItemStack stack = playerEntity.func_184586_b(hand);
        if (stack.func_77973_b() != this) {
            return ClickProcessingState.DEFAULT;
        }
        if (KeyBindingManager.getInstance().isResetMeasuringTapeKeyPressed()) {
            this.clear(stack);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new MeasurementsResetPacket());
            return ClickProcessingState.DEFAULT;
        }
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return ClickProcessingState.DEFAULT;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e();
        Optional<Vector3d> startPointHandler = this.getStart(stack);
        if (!startPointHandler.isPresent()) {
            this.setStart(stack, this.getMode(stack).getType().adaptPosition(hitVector));
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }
        Vector3d startPoint = startPointHandler.get();
        Vector3d endPoint = this.getMode(stack).getType().adaptPosition(hitVector);
        MeasuringManager.getInstance().createAndSend(startPoint, endPoint, this.getMode(stack));
        this.clear(stack);
        return new ClickProcessingState(true, Event.Result.ALLOW);
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.func_201670_d()) {
            return;
        }
        if (!(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)entityIn;
        if (stack.func_77973_b() != this) {
            return;
        }
        Optional<Vector3d> startPointHandler = this.getStart(stack);
        if (!startPointHandler.isPresent()) {
            return;
        }
        if (KeyBindingManager.getInstance().isResetMeasuringTapeKeyPressed()) {
            this.clear(stack);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new MeasurementsResetPacket());
            return;
        }
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e();
        Vector3d startPoint = startPointHandler.get();
        Vector3d endPoint = this.getMode(stack).getType().adaptPosition(hitVector);
        MeasuringManager.getInstance().createAndSend(startPoint, endPoint, this.getMode(stack));
    }

    @Override
    @NotNull
    public Optional<Vector3d> getStart(@NotNull ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b("start")) {
            return Optional.empty();
        }
        CompoundNBT start = stack.func_196082_o().func_74775_l("start");
        return Optional.of(new Vector3d(start.func_74769_h("x"), start.func_74769_h("y"), start.func_74769_h("z")));
    }

    @Override
    public void setStart(@NotNull ItemStack stack, @NotNull Vector3d start) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74780_a("x", start.func_82615_a());
        compoundNBT.func_74780_a("y", start.func_82617_b());
        compoundNBT.func_74780_a("z", start.func_82616_c());
        stack.func_196082_o().func_218657_a("start", (INBT)compoundNBT);
    }

    @Override
    public void clear(@NotNull ItemStack stack) {
        stack.func_196082_o().func_82580_o("start");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (KeyBindingManager.getInstance().areBindingsInitialized()) {
            Configuration.getInstance().getCommon().helpText(LocalStrings.HelpTapeMeasure, tooltip, Minecraft.func_71410_x().field_71474_y.field_74313_G.func_238171_j_().getString(), Minecraft.func_71410_x().field_71474_y.field_74313_G.func_238171_j_().getString(), KeyBindingManager.getInstance().getResetMeasuringTapeKeyBinding().func_238171_j_().getString(), KeyBindingManager.getInstance().getOpenToolMenuKeybinding().func_238171_j_().getString());
        }
    }
}

