/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.List;
import java.util.stream.Stream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.exceptions.SealingNotSupportedException;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.network.packets.TileEntityUpdatedPacket;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleUsePatternItem
extends Item
implements IPatternItem {
    public SingleUsePatternItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(ItemStack stack) {
        if (stack.func_196082_o().isEmpty()) {
            return EmptySnapshot.Stack.INSTANCE;
        }
        return new SingleBlockMultiStateItemStack(stack);
    }

    @NotNull
    public ActionResultType func_195939_a(@NotNull ItemUseContext context) {
        IMultiStateItemStack contents = this.createItemStack(context.func_195996_i());
        if (contents.getStatistics().isEmpty()) {
            if (context.func_195999_j() == null) {
                return ActionResultType.FAIL;
            }
            if (!context.func_195999_j().func_184812_l_()) {
                return ActionResultType.FAIL;
            }
            if (!context.func_195999_j().func_213453_ef()) {
                return ActionResultType.FAIL;
            }
            IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((IWorld)context.func_195991_k(), context.func_195995_a());
            ItemStack snapshotPatternStack = areaMutator.createSnapshot().toItemStack().toPatternStack();
            context.func_195996_i().func_77982_d(snapshotPatternStack.func_196082_o().func_74737_b());
            return ActionResultType.SUCCESS;
        }
        return this.tryPlace(new BlockItemUseContext(context));
    }

    @NotNull
    public ActionResultType tryPlace(@NotNull BlockItemUseContext context) {
        boolean hasRequiredBits;
        if (context.func_195999_j() == null) {
            return ActionResultType.FAIL;
        }
        IMultiStateItemStack source = this.createItemStack(context.func_195996_i());
        IMultiStateSnapshot sourceSnapshot = source.createSnapshot();
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((IWorld)context.func_195991_k(), context.func_195995_a());
        IMultiStateSnapshot attemptTarget = areaMutator.createSnapshot();
        boolean noCollisions = ((Stream)source.stream().sequential()).allMatch(stateEntryInfo -> {
            try {
                attemptTarget.setInAreaTarget(stateEntryInfo.getState(), stateEntryInfo.getStartPoint());
                return true;
            }
            catch (SpaceOccupiedException exception) {
                return false;
            }
        });
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.func_195999_j());
        boolean bl = hasRequiredBits = context.func_195999_j().func_184812_l_() || sourceSnapshot.getStatics().getStateCounts().entrySet().stream().allMatch(e -> playerBitInventory.canExtract((BlockState)e.getKey(), (Integer)e.getValue()));
        if (noCollisions && hasRequiredBits) {
            TileEntity tileEntityCandidate;
            try (IBatchMutation ignored = areaMutator.batch();){
                ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                    try {
                        areaMutator.setInAreaTarget(stateEntryInfo.getState(), stateEntryInfo.getStartPoint());
                    }
                    catch (SpaceOccupiedException spaceOccupiedException) {
                        // empty catch block
                    }
                });
            }
            if (!context.func_195999_j().func_184812_l_()) {
                sourceSnapshot.getStatics().getStateCounts().forEach(playerBitInventory::extract);
            }
            if ((tileEntityCandidate = context.func_195991_k().func_175625_s(context.func_195995_a())) instanceof IMultiStateBlockEntity) {
                IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntityCandidate;
                Direction placementDirection = context.func_195999_j() == null ? Direction.NORTH : context.func_195999_j().func_174811_aO().func_176734_d();
                int horizontalIndex = placementDirection.func_176736_b();
                int rotationCount = horizontalIndex - 4;
                if (rotationCount < 0) {
                    rotationCount += 4;
                }
                multiStateBlockEntity.rotate(Direction.Axis.Y, rotationCount);
                if (!context.func_195991_k().func_201670_d()) {
                    context.func_195991_k().func_184138_a(context.func_195995_a(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 3);
                    ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new TileEntityUpdatedPacket(tileEntityCandidate), context.func_195991_k().func_175726_f(context.func_195995_a()));
                }
            }
            return this.determineSuccessResult(context);
        }
        return ActionResultType.FAIL;
    }

    protected ActionResultType determineSuccessResult(BlockItemUseContext context) {
        if (context.func_195999_j() != null && context.func_195999_j().func_184812_l_()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    @Override
    @NotNull
    public ItemStack seal(@NotNull ItemStack source) throws SealingNotSupportedException {
        if (source.func_77973_b() == this) {
            if (!(source.func_77973_b() instanceof IMultiUsePatternItem)) {
                ItemStack seal = new ItemStack((IItemProvider)ModItems.MULTI_USE_PATTERN_ITEM.get());
                seal.func_77982_d(source.func_196082_o().func_74737_b());
                return seal;
            }
            throw new SealingNotSupportedException();
        }
        return source;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        if (Minecraft.func_71410_x().func_228018_at_() != null && Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent("        "));
            tooltip.add((ITextComponent)new StringTextComponent("        "));
        }
        Configuration.getInstance().getCommon().helpText(LocalStrings.HelpSimplePattern, tooltip, new String[0]);
    }
}

