/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.keys;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.client.screens.RadialToolModeSelectionScreen;
import mod.chiselsandbits.keys.contexts.HoldsSpecificItemInHandKeyConflictContext;
import mod.chiselsandbits.keys.contexts.HoldsWithToolItemInHandKeyConflictContext;
import mod.chiselsandbits.keys.contexts.SpecificScreenOpenKeyConflictContext;
import mod.chiselsandbits.network.packets.HeldToolModeChangedPacket;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class KeyBindingManager {
    private KeyBinding openToolMenuKeybinding = null;
    private KeyBinding cycleToolMenuLeftKeybinding = null;
    private KeyBinding cycleToolMenuRightKeybinding = null;
    private KeyBinding resetMeasuringTapeKeyBinding = null;
    private boolean toolMenuKeyWasDown = false;
    private int toolModeSelectionPlusCoolDown = 15;
    private int toolModeSelectionMinusCoolDown = 15;
    private static final KeyBindingManager INSTANCE = new KeyBindingManager();

    public static KeyBindingManager getInstance() {
        return INSTANCE;
    }

    private KeyBindingManager() {
    }

    public void onModInitialization() {
        this.openToolMenuKeybinding = new KeyBinding("key.modded-tool.open", (IKeyConflictContext)HoldsWithToolItemInHandKeyConflictContext.getInstance(), InputMappings.Type.KEYSYM, 82, "key.chiselsandbits.category");
        ClientRegistry.registerKeyBinding((KeyBinding)this.openToolMenuKeybinding);
        this.cycleToolMenuLeftKeybinding = new KeyBinding("key.modded-tool.cycle.left", (IKeyConflictContext)SpecificScreenOpenKeyConflictContext.RADIAL_TOOL_MENU, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.chiselsandbits.category");
        ClientRegistry.registerKeyBinding((KeyBinding)this.cycleToolMenuLeftKeybinding);
        this.cycleToolMenuRightKeybinding = new KeyBinding("key.modded-tool.cycle.right", (IKeyConflictContext)SpecificScreenOpenKeyConflictContext.RADIAL_TOOL_MENU, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.chiselsandbits.category");
        ClientRegistry.registerKeyBinding((KeyBinding)this.cycleToolMenuRightKeybinding);
        this.resetMeasuringTapeKeyBinding = new KeyBinding("key.measuring-tape.reset", (IKeyConflictContext)HoldsSpecificItemInHandKeyConflictContext.MEASURING_TAPE, KeyModifier.SHIFT, InputMappings.Type.MOUSE, 1, "key.chiselsandbits.category");
        ClientRegistry.registerKeyBinding((KeyBinding)this.resetMeasuringTapeKeyBinding);
    }

    @SubscribeEvent
    public static void handleClientTickEvent(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.START) {
            return;
        }
        KeyBindingManager.getInstance().handleKeyPresses();
    }

    public void handleKeyPresses() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            ItemStack inHand;
            boolean toolMenuKeyIsDown = this.isOpenToolMenuKeyPressed();
            if (toolMenuKeyIsDown && !this.toolMenuKeyWasDown && this.isOpenToolMenuKeyPressed() && mc.field_71462_r == null && !(inHand = ItemStackUtils.getModeItemStackFromPlayer((PlayerEntity)mc.field_71439_g)).func_190926_b() && inHand.func_77973_b() instanceof IWithModeItem) {
                try {
                    IWithModeItem withModeItem = (IWithModeItem)inHand.func_77973_b();
                    mc.func_147108_a(RadialToolModeSelectionScreen.create(withModeItem, inHand));
                }
                catch (ClassCastException withModeItem) {
                    // empty catch block
                }
            }
            this.toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            this.toolMenuKeyWasDown = true;
        }
        if (mc.field_71462_r instanceof RadialToolModeSelectionScreen) {
            RadialToolModeSelectionScreen radialToolMenuScreen = (RadialToolModeSelectionScreen)mc.field_71462_r;
            if (this.toolModeSelectionPlusCoolDown == 0 && this.isCycleToolMenuRightKeyPressed()) {
                radialToolMenuScreen.onMoveSelectionToTheRight();
            }
            if (this.toolModeSelectionMinusCoolDown == 0 && this.isCycleToolMenuLeftKeyPressed()) {
                radialToolMenuScreen.onMoveSelectionToTheLeft();
            }
        } else if (ItemStackUtils.getModeItemStackFromPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g).func_77973_b() instanceof IWithModeItem) {
            ItemStack stack = ItemStackUtils.getModeItemStackFromPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            IWithModeItem withModeItem = (IWithModeItem)stack.func_77973_b();
            ArrayList candidates = Lists.newArrayList(withModeItem.getPossibleModes());
            Object cur = withModeItem.getMode(stack);
            int workingIndex = candidates.indexOf(cur);
            if (this.toolModeSelectionPlusCoolDown == 15 && this.isCycleToolMenuRightKeyPressed()) {
                if (++workingIndex >= candidates.size()) {
                    workingIndex = 0;
                }
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(workingIndex));
                this.toolModeSelectionPlusCoolDown = 0;
            } else if (this.isCycleToolMenuRightKeyPressed() && this.toolModeSelectionPlusCoolDown <= 14) {
                ++this.toolModeSelectionPlusCoolDown;
            } else if (this.toolModeSelectionMinusCoolDown == 15 && this.isCycleToolMenuLeftKeyPressed()) {
                if (--workingIndex < 0) {
                    workingIndex = candidates.size() - 1;
                }
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(workingIndex));
                this.toolModeSelectionMinusCoolDown = 0;
            } else if (this.isCycleToolMenuLeftKeyPressed() && this.toolModeSelectionMinusCoolDown <= 14) {
                ++this.toolModeSelectionMinusCoolDown;
            }
        }
        if (!this.isCycleToolMenuRightKeyPressed()) {
            this.toolModeSelectionPlusCoolDown = 15;
        }
        if (!this.isCycleToolMenuLeftKeyPressed()) {
            this.toolModeSelectionMinusCoolDown = 15;
        }
    }

    public boolean isKeyDown(KeyBinding keybinding) {
        if (keybinding.func_197986_j()) {
            return false;
        }
        boolean isDown = false;
        switch (keybinding.getKey().func_197938_b()) {
            case KEYSYM: {
                isDown = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keybinding.getKey().func_197937_c());
                break;
            }
            case MOUSE: {
                isDown = GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keybinding.getKey().func_197937_c()) == 1;
            }
        }
        return isDown && keybinding.getKeyConflictContext().isActive() && keybinding.getKeyModifier().isActive(keybinding.getKeyConflictContext());
    }

    public boolean areBindingsInitialized() {
        return this.resetMeasuringTapeKeyBinding != null;
    }

    public KeyBinding getResetMeasuringTapeKeyBinding() {
        if (this.resetMeasuringTapeKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.resetMeasuringTapeKeyBinding;
    }

    public KeyBinding getOpenToolMenuKeybinding() {
        if (this.openToolMenuKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.openToolMenuKeybinding;
    }

    public KeyBinding getCycleToolMenuLeftKeybinding() {
        if (this.cycleToolMenuLeftKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.cycleToolMenuLeftKeybinding;
    }

    public KeyBinding getCycleToolMenuRightKeybinding() {
        if (this.cycleToolMenuRightKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.cycleToolMenuRightKeybinding;
    }

    public boolean isResetMeasuringTapeKeyPressed() {
        return this.isKeyDown(this.getResetMeasuringTapeKeyBinding());
    }

    public boolean isOpenToolMenuKeyPressed() {
        return this.isKeyDown(this.getOpenToolMenuKeybinding());
    }

    public boolean isCycleToolMenuLeftKeyPressed() {
        return this.isKeyDown(this.getCycleToolMenuLeftKeybinding());
    }

    public boolean isCycleToolMenuRightKeyPressed() {
        return this.isKeyDown(this.getCycleToolMenuRightKeybinding());
    }
}

