/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.mutator;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.ISingleStateAreaShareIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkSection;

public class ChiselAdaptingWorldMutator
implements IWorldAreaMutator {
    public static final BlockState DEFAULT_STATE = Blocks.field_150348_b.func_176223_P();
    private final IWorld world;
    private final BlockPos pos;

    public ChiselAdaptingWorldMutator(IWorld world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).createNewShapeIdentifier();
        }
        return new PreAdaptedShapeIdentifier(this.getWorld().func_180495_p(this.getPos()));
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).stream();
        }
        BlockState currentState = this.getWorld().func_180495_p(this.getPos());
        if (IEligibilityManager.getInstance().canBeChiseled(currentState) || currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState, this.getPos(), (IBlockReader)this.getWorld()), this.getPos())) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(currentState, this.getWorld(), this.getPos(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0) {
            return Optional.empty();
        }
        if (inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            return Optional.empty();
        }
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).getInAreaTarget(inAreaTarget);
        }
        BlockState currentState = this.getWorld().func_180495_p(this.getPos());
        return Optional.of(new MutablePreAdaptedStateEntry(currentState, this.getWorld(), this.getPos(), (Vector3i)new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())), this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(Vector3d inAreaTarget) {
        return !(inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).createSnapshot();
        }
        BlockState blockState = this.getWorld().func_180495_p(this.getPos());
        ChunkSection temporarySection = new ChunkSection(0);
        for (int x = 0; x < StateEntrySize.current().getBitsPerBlockSide(); ++x) {
            for (int y = 0; y < StateEntrySize.current().getBitsPerBlockSide(); ++y) {
                for (int z = 0; z < StateEntrySize.current().getBitsPerBlockSide(); ++z) {
                    temporarySection.func_222629_a(x, y, z, blockState);
                }
            }
        }
        return MultiStateSnapshotUtils.createFromSection(temporarySection);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        block5: {
            BlockState currentState;
            block4: {
                TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
                if (tileEntity instanceof IMultiStateBlockEntity) {
                    return ((IMultiStateBlockEntity)tileEntity).streamWithPositionMutator(positionMutator);
                }
                currentState = this.getWorld().func_180495_p(this.getPos());
                if (IEligibilityManager.getInstance().canBeChiseled(currentState)) break block4;
                if (!currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState, this.getPos(), (IBlockReader)this.getWorld()), this.getPos())) break block5;
            }
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new MutablePreAdaptedStateEntry(currentState, this.getWorld(), this.getPos(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Vector3d getInWorldStartPoint() {
        return Vector3d.func_237491_b_((Vector3i)this.pos);
    }

    @Override
    public Vector3d getInWorldEndPoint() {
        return Vector3d.func_237491_b_((Vector3i)this.pos).func_72441_c((double)(15.0f * StateEntrySize.current().getSizePerBit()), (double)(15.0f * StateEntrySize.current().getSizePerBit()), (double)(15.0f * StateEntrySize.current().getSizePerBit()));
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).mutableStream();
        }
        BlockState currentState = this.getWorld().func_180495_p(this.getPos());
        if (IEligibilityManager.getInstance().canBeChiseled(currentState)) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(currentState, this.getWorld(), this.getPos(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vector3d inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset greater or equal to 0. Requested was: " + inAreaTarget);
        }
        if (inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset smaller then 1. Requested was: " + inAreaTarget);
        }
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            ((IMultiStateBlockEntity)tileEntity).setInAreaTarget(blockState, inAreaTarget);
            return;
        }
        BlockState currentState = this.getWorld().func_180495_p(this.getPos());
        if (!currentState.isAir((IBlockReader)this.getWorld(), this.getPos())) {
            throw new SpaceOccupiedException();
        }
        Optional<Block> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(blockState);
        if (optionalWithConvertedBlock.isPresent()) {
            Block convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().func_180501_a(this.getPos(), convertedBlock.func_176223_P(), 18);
            TileEntity convertedTileEntity = this.getWorld().func_175625_s(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                ((IMultiStateBlockEntity)convertedTileEntity).initializeWith(currentState);
                ((IMultiStateBlockEntity)convertedTileEntity).setInAreaTarget(blockState, inAreaTarget);
                return;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + currentState + " into a chiseled variant failed.");
        }
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        this.setInAreaTarget(blockState, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset greater or equal to 0. Requested was: " + inAreaTarget);
        }
        if (inAreaTarget.func_82615_a() > 1.0 || inAreaTarget.func_82617_b() > 1.0 || inAreaTarget.func_82616_c() > 1.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset smaller then 1. Requested was: " + inAreaTarget);
        }
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            ((IMultiStateBlockEntity)tileEntity).clearInAreaTarget(inAreaTarget);
            return;
        }
        BlockState currentState = this.getWorld().func_180495_p(this.getPos());
        if (currentState.isAir((IBlockReader)this.getWorld(), this.getPos())) {
            return;
        }
        Optional<Block> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(currentState);
        if (optionalWithConvertedBlock.isPresent()) {
            Block convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().func_180501_a(this.getPos(), convertedBlock.func_176223_P(), 18);
            TileEntity convertedTileEntity = this.getWorld().func_175625_s(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                ((IMultiStateBlockEntity)convertedTileEntity).initializeWith(currentState);
                ((IMultiStateBlockEntity)convertedTileEntity).clearInAreaTarget(inAreaTarget);
                return;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + currentState + " into a chiseled variant failed.");
        }
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).inWorldMutableStream();
        }
        BlockState currentState = this.getWorld().func_180495_p(this.getPos());
        if (IEligibilityManager.getInstance().canBeChiseled(currentState) || currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState, this.getPos(), (IBlockReader)this.getWorld()), this.getPos())) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(currentState, this.getWorld(), this.getPos(), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public IBatchMutation batch() {
        Optional<Block> optionalWithConvertedBlock;
        BlockState currentState;
        TileEntity tileEntity = this.getWorld().func_175625_s(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).batch();
        }
        BlockState initializationState = currentState = this.getWorld().func_180495_p(this.getPos());
        if (currentState.isAir((IBlockReader)this.getWorld(), this.getPos())) {
            currentState = DEFAULT_STATE;
            initializationState = Blocks.field_150350_a.func_176223_P();
        }
        if ((optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isPresent()) {
            Block convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().func_180501_a(this.getPos(), convertedBlock.func_176223_P(), 18);
            TileEntity convertedTileEntity = this.getWorld().func_175625_s(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                ((IMultiStateBlockEntity)convertedTileEntity).initializeWith(initializationState);
                return ((IMultiStateBlockEntity)convertedTileEntity).batch();
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + currentState + " into a chiseled variant failed.");
        }
        return () -> {};
    }

    private static class PreAdaptedShapeIdentifier
    implements ISingleStateAreaShareIdentifier {
        private final int blockState;

        private PreAdaptedShapeIdentifier(BlockState blockState) {
            this.blockState = IBlockStateIdManager.getInstance().getIdFrom(blockState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PreAdaptedShapeIdentifier)) {
                return false;
            }
            PreAdaptedShapeIdentifier that = (PreAdaptedShapeIdentifier)o;
            return this.blockState == that.blockState;
        }

        public int hashCode() {
            return Objects.hash(this.blockState);
        }
    }

    private static class MutablePreAdaptedStateEntry
    implements IInWorldMutableStateEntryInfo {
        private final BlockState blockState;
        private final IWorld world;
        private final Vector3d startPoint;
        private final Vector3d endPoint;
        private final BlockPos blockPos;
        private final StateSetter setCallback;
        private final StateClearer clearCallback;

        public MutablePreAdaptedStateEntry(BlockState blockState, IWorld world, BlockPos blockPos, Vector3i inBlockOffset, StateSetter setCallback, StateClearer clearCallback) {
            this.blockState = blockState;
            this.world = world;
            this.blockPos = blockPos;
            this.startPoint = Vector3d.func_237491_b_((Vector3i)inBlockOffset).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.setCallback = setCallback;
            this.clearCallback = clearCallback;
            this.endPoint = this.startPoint.func_72441_c((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        }

        @Override
        public BlockState getState() {
            return this.blockState;
        }

        @Override
        public Vector3d getStartPoint() {
            return this.startPoint;
        }

        @Override
        public Vector3d getEndPoint() {
            return this.endPoint;
        }

        @Override
        public IWorld getWorld() {
            return this.world;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        @Override
        public void setState(BlockState blockState) throws SpaceOccupiedException {
            this.setCallback.accept(blockState, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.clearCallback.accept(this.getStartPoint());
        }
    }
}

