/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.mutator;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessorWithVoxelShape;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IWorldObject;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.multistate.mutator.ChiselAdaptingWorldMutator;
import mod.chiselsandbits.multistate.snapshot.MultiBlockMultiStateSnapshot;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class WorldWrappingMutator
implements IWorldAreaMutator,
IAreaAccessorWithVoxelShape {
    private final IWorld world;
    private final Vector3d startPoint;
    private final Vector3d endPoint;

    public WorldWrappingMutator(IWorld world, Vector3d startPoint, Vector3d endPoint) {
        this.world = world;
        this.startPoint = new Vector3d(Math.min(startPoint.func_82615_a(), endPoint.func_82615_a()), Math.min(startPoint.func_82617_b(), endPoint.func_82617_b()), Math.min(startPoint.func_82616_c(), endPoint.func_82616_c()));
        this.endPoint = new Vector3d(Math.max(startPoint.func_82615_a(), endPoint.func_82615_a()), Math.max(startPoint.func_82617_b(), endPoint.func_82617_b()), Math.max(startPoint.func_82616_c(), endPoint.func_82616_c()));
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        BlockPos endBlockPos;
        BlockPos startBlockPos = new BlockPos(this.getInWorldStartPoint());
        Stream<BlockPos> positionStream = startBlockPos.equals((Object)(endBlockPos = new BlockPos(this.getInWorldEndPoint()))) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.func_177958_n(), startBlockPos.func_177956_o(), startBlockPos.func_177952_p(), endBlockPos.func_177958_n(), endBlockPos.func_177956_o(), endBlockPos.func_177952_p());
        Collection identifiers = positionStream.map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).map(ChiselAdaptingWorldMutator::createNewShapeIdentifier).collect(Collectors.toList());
        return new Identifier(identifiers, this.startPoint, this.endPoint);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        BlockPos endBlockPos;
        BlockPos startBlockPos = new BlockPos(this.getInWorldStartPoint());
        Stream<BlockPos> positionStream = startBlockPos.equals((Object)(endBlockPos = new BlockPos(this.getInWorldEndPoint()))) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.func_177958_n(), startBlockPos.func_177956_o(), startBlockPos.func_177952_p(), endBlockPos.func_177958_n(), endBlockPos.func_177956_o(), endBlockPos.func_177952_p());
        return positionStream.flatMap(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos).inWorldMutableStream().filter(entry -> this.getInWorldBoundingBox().func_72326_a(entry.getBoundingBox()) || entry.getBoundingBox().func_72326_a(this.getInWorldBoundingBox())).map(s -> new PositionAdaptingMutableStateEntry((IMutableStateEntryInfo)s, (BlockPos)blockPos, this.world)));
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        return Optional.empty();
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        return Optional.empty();
    }

    @Override
    public boolean isInside(Vector3d inAreaTarget) {
        return this.getInWorldBoundingBox().func_72318_a(inAreaTarget);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        return this.isInside(Vector3d.func_237491_b_((Vector3i)inAreaBlockPosOffset).func_178787_e(inBlockTarget));
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        BlockPos endBlockPos;
        BlockPos startBlockPos = new BlockPos(this.getInWorldStartPoint());
        Stream<BlockPos> positionStream = startBlockPos.equals((Object)(endBlockPos = new BlockPos(this.getInWorldEndPoint()))) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.func_177958_n(), startBlockPos.func_177956_o(), startBlockPos.func_177952_p(), endBlockPos.func_177958_n(), endBlockPos.func_177956_o(), endBlockPos.func_177952_p());
        Map<BlockPos, IMultiStateSnapshot> snapshots = positionStream.collect(Collectors.toMap(Function.identity(), blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos).createSnapshot()));
        return new MultiBlockMultiStateSnapshot(snapshots, this.getInWorldStartPoint(), this.getInWorldEndPoint());
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint().func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.getInWorldEndPoint().func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())).map(positionMutator::mutate).map(position -> Vector3d.func_237491_b_((Vector3i)position).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())).map(position -> {
            BlockPos blockPos = new BlockPos(position);
            Vector3d inBlockOffset = position.func_178788_d(Vector3d.func_237491_b_((Vector3i)blockPos));
            return this.getInBlockTarget(blockPos, inBlockOffset);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getInWorldStartPoint() {
        return this.startPoint;
    }

    @Override
    public Vector3d getInWorldEndPoint() {
        return this.endPoint;
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).flatMap(blockPos -> this.positionBasedMutableStream((BlockPos)blockPos).map(mutableEntry -> new PositionAdaptingMutableStateEntry((IMutableStateEntryInfo)mutableEntry, (BlockPos)blockPos, this.getWorld()))).filter(entry -> this.getInWorldBoundingBox().func_72326_a(entry.getInWorldBoundingBox()) || entry.getInWorldBoundingBox().func_72326_a(this.getInWorldBoundingBox())).map(IMutableStateEntryInfo.class::cast);
    }

    private Stream<IMutableStateEntryInfo> positionBasedMutableStream(BlockPos position) {
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), position);
        return innerMutator.mutableStream();
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vector3d inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0) {
            throw new IllegalArgumentException(String.format("The in area target can not have a negative component: %s", inAreaTarget));
        }
        Vector3d actualTarget = this.getInWorldStartPoint().func_178787_e(inAreaTarget);
        if (actualTarget.func_82615_a() >= this.getInWorldEndPoint().func_82615_a() || actualTarget.func_82617_b() >= this.getInWorldEndPoint().func_82617_b() || actualTarget.func_82616_c() >= this.getInWorldEndPoint().func_82616_c()) {
            throw new IllegalArgumentException(String.format("The in area target is larger then the allowed size:%s", inAreaTarget));
        }
        BlockPos blockPosTarget = new BlockPos(actualTarget);
        Vector3d inBlockPosTarget = actualTarget.func_178788_d(Vector3d.func_237491_b_((Vector3i)blockPosTarget));
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), blockPosTarget);
        innerMutator.setInAreaTarget(blockState, inBlockPosTarget);
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) throws SpaceOccupiedException {
        BlockPos startPos = new BlockPos(this.getInWorldStartPoint());
        BlockPos targetPos = startPos.func_177971_a((Vector3i)inAreaBlockPosOffset);
        Vector3d target = Vector3d.func_237491_b_((Vector3i)targetPos).func_178787_e(inBlockTarget);
        if (target.func_82615_a() < this.getInWorldStartPoint().func_82615_a() || target.func_82617_b() < this.getInWorldStartPoint().func_82617_b() || target.func_82616_c() < this.getInWorldStartPoint().func_82616_c()) {
            throw new IllegalArgumentException(String.format("The target can not be smaller then the start point: %s", target));
        }
        if (target.func_82615_a() >= this.getInWorldEndPoint().func_82615_a() || target.func_82617_b() >= this.getInWorldEndPoint().func_82617_b() || target.func_82616_c() >= this.getInWorldEndPoint().func_82616_c()) {
            throw new IllegalArgumentException(String.format("The target can not be greater then the start point: %s", target));
        }
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), targetPos);
        innerMutator.setInBlockTarget(blockState, BlockPos.field_177992_a, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0) {
            throw new IllegalArgumentException(String.format("The in area target can not have a negative component: %s", inAreaTarget));
        }
        Vector3d actualTarget = this.getInWorldStartPoint().func_178787_e(inAreaTarget);
        if (actualTarget.func_82615_a() >= this.getInWorldEndPoint().func_82615_a() || actualTarget.func_82617_b() >= this.getInWorldEndPoint().func_82617_b() || actualTarget.func_82616_c() >= this.getInWorldEndPoint().func_82616_c()) {
            throw new IllegalArgumentException(String.format("The in area target is larger then the allowed size:%s", inAreaTarget));
        }
        BlockPos blockPosTarget = new BlockPos(actualTarget);
        Vector3d inBlockPosTarget = actualTarget.func_178788_d(Vector3d.func_237491_b_((Vector3i)blockPosTarget));
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), blockPosTarget);
        innerMutator.clearInAreaTarget(inBlockPosTarget);
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        BlockPos startPos = new BlockPos(this.getInWorldStartPoint());
        BlockPos targetPos = startPos.func_177971_a((Vector3i)inAreaBlockPosOffset);
        Vector3d target = Vector3d.func_237491_b_((Vector3i)targetPos).func_178787_e(inBlockTarget);
        if (target.func_82615_a() < this.getInWorldStartPoint().func_82615_a() || target.func_82617_b() < this.getInWorldStartPoint().func_82617_b() || target.func_82616_c() < this.getInWorldStartPoint().func_82616_c()) {
            throw new IllegalArgumentException(String.format("The target can not be smaller then the start point: %s", target));
        }
        if (target.func_82615_a() >= this.getInWorldEndPoint().func_82615_a() || target.func_82617_b() >= this.getInWorldEndPoint().func_82617_b() || target.func_82616_c() >= this.getInWorldEndPoint().func_82616_c()) {
            throw new IllegalArgumentException(String.format("The target can not be greater then the start point: %s", target));
        }
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), targetPos);
        innerMutator.clearInBlockTarget(BlockPos.field_177992_a, inBlockTarget);
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).flatMap(blockPos -> this.positionBasedInWorldMutableStream((BlockPos)blockPos).filter(entry -> this.getInWorldBoundingBox().func_72326_a(entry.getInWorldBoundingBox()) || entry.getInWorldBoundingBox().func_72326_a(this.getInWorldBoundingBox())));
    }

    private Stream<IInWorldMutableStateEntryInfo> positionBasedInWorldMutableStream(BlockPos position) {
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), position);
        return innerMutator.inWorldMutableStream();
    }

    @Override
    public IBatchMutation batch() {
        return new BatchMutationLock(BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).map(ChiselAdaptingWorldMutator::batch).collect(Collectors.toList()));
    }

    @Override
    public VoxelShape provideShape(Function<IAreaAccessor, Predicate<IStateEntryInfo>> selectablePredicateBuilder, BlockPos offset, boolean simplify) {
        VoxelShape areaShape = VoxelShapes.func_197881_a((AxisAlignedBB)this.getInWorldBoundingBox().func_186670_a(VectorUtils.invert(new BlockPos(this.getInWorldStartPoint()))).func_186670_a(offset));
        VoxelShape containedShape = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (BlockPos)blockPos)).map(a -> IVoxelShapeManager.getInstance().get((IAreaAccessor)a, new BlockPos(a.getInWorldStartPoint()).func_177971_a((Vector3i)VectorUtils.invert(new BlockPos(this.getInWorldStartPoint()))).func_177971_a((Vector3i)offset), selectablePredicateBuilder, simplify)).reduce(VoxelShapes.func_197880_a(), (voxelShape, bbShape) -> VoxelShapes.func_197882_b((VoxelShape)voxelShape, (VoxelShape)bbShape, (IBooleanFunction)IBooleanFunction.field_223244_o_), (voxelShape, voxelShape2) -> VoxelShapes.func_197882_b((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VoxelShape requestedShape = VoxelShapes.func_197882_b((VoxelShape)areaShape, (VoxelShape)containedShape, (IBooleanFunction)IBooleanFunction.field_223238_i_);
        return simplify ? requestedShape.func_197753_c() : requestedShape;
    }

    private static final class Identifier
    implements IAreaShapeIdentifier {
        private final Collection<IAreaShapeIdentifier> inners;
        private final Vector3d startPoint;
        private final Vector3d endPoint;

        public Identifier(Collection<IAreaShapeIdentifier> innerSnapshots, Vector3d startPoint, Vector3d endPoint) {
            this.inners = innerSnapshots;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.inners.equals(that.inners) && this.startPoint.equals((Object)that.startPoint) && this.endPoint.equals((Object)that.endPoint);
        }

        public int hashCode() {
            return Objects.hash(this.inners, this.startPoint, this.endPoint);
        }
    }

    private static final class BatchMutationLock
    implements IBatchMutation {
        private final Iterable<IBatchMutation> innerLocks;

        private BatchMutationLock(Iterable<IBatchMutation> innerLocks) {
            this.innerLocks = innerLocks;
        }

        @Override
        public void close() {
            for (IBatchMutation innerLock : this.innerLocks) {
                innerLock.close();
            }
        }
    }

    private static final class PositionAdaptingMutableStateEntry
    implements IMutableStateEntryInfo,
    IWorldObject {
        private final IMutableStateEntryInfo source;
        private final Vector3d offSet;
        private final IWorld world;

        private PositionAdaptingMutableStateEntry(IMutableStateEntryInfo source, BlockPos position, IWorld world) {
            this.source = source;
            this.offSet = Vector3d.func_237491_b_((Vector3i)position);
            this.world = world;
        }

        @Override
        public BlockState getState() {
            return this.source.getState();
        }

        @Override
        public Vector3d getStartPoint() {
            return this.source.getStartPoint().func_178787_e(this.offSet);
        }

        @Override
        public Vector3d getEndPoint() {
            return this.source.getEndPoint().func_178787_e(this.offSet);
        }

        @Override
        public void setState(BlockState blockState) throws SpaceOccupiedException {
            this.source.setState(blockState);
        }

        @Override
        public void clear() {
            this.source.clear();
        }

        @Override
        public IWorld getWorld() {
            return this.world;
        }

        @Override
        public Vector3d getInWorldStartPoint() {
            return this.getStartPoint();
        }

        @Override
        public Vector3d getInWorldEndPoint() {
            return this.getEndPoint();
        }
    }
}

