/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.snapshot;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.item.ChiseledBlockItem;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.ChunkSectionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.commons.lang3.NotImplementedException;

public class LazilyDecodingSingleBlockMultiStateSnapshot
implements IMultiStateSnapshot {
    private CompoundNBT lazyNbtCompound;
    private boolean loaded = false;
    private ChunkSection lazyChunkSection = new ChunkSection(0);
    private IMultiStateObjectStatistics stateObjectStatistics = null;

    public LazilyDecodingSingleBlockMultiStateSnapshot(CompoundNBT lazyNbtCompound) {
        this.lazyNbtCompound = lazyNbtCompound;
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        this.load();
        return new Identifier(this.lazyChunkSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        this.load();
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.lazyChunkSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(Vector3d inAreaTarget) {
        return !(inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        this.load();
        BlockState currentState = this.lazyChunkSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        return currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState), BlockPos.field_177992_a) ? Optional.empty() : Optional.of(new StateEntry(currentState, (Vector3i)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        if (!this.loaded) {
            CompoundNBT copyNbtCompound = this.lazyNbtCompound.func_74737_b();
            return new LazilyDecodingSingleBlockMultiStateSnapshot(copyNbtCompound);
        }
        return MultiStateSnapshotUtils.createFromSection(this.lazyChunkSection);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        this.load();
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new StateEntry(this.lazyChunkSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        ChunkSectionUtils.deserializeNBT(this.lazyChunkSection, this.lazyNbtCompound);
        this.loaded = true;
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        this.load();
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.lazyChunkSection.func_177485_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), (Vector3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(BlockState blockState, Vector3d inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        this.load();
        BlockState currentState = this.lazyChunkSection.func_177485_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p());
        if (!currentState.isAir((IBlockReader)new SingleBlockBlockReader(currentState), BlockPos.field_177992_a)) {
            throw new SpaceOccupiedException();
        }
        this.lazyChunkSection.func_177484_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p(), blockState, true);
    }

    @Override
    public void setInBlockTarget(BlockState blockState, BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockState, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vector3d inAreaTarget) {
        if (inAreaTarget.func_82615_a() < 0.0 || inAreaTarget.func_82617_b() < 0.0 || inAreaTarget.func_82616_c() < 0.0 || inAreaTarget.func_82615_a() >= 1.0 || inAreaTarget.func_82617_b() >= 1.0 || inAreaTarget.func_82616_c() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        this.load();
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        this.lazyChunkSection.func_177484_a(inAreaPos.func_177958_n(), inAreaPos.func_177956_o(), inAreaPos.func_177952_p(), blockState, true);
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vector3d inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.field_177992_a)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateItemStack toItemStack() {
        BlockState primaryState = this.determinePrimaryState();
        Material blockMaterial = primaryState.func_185904_a();
        Material conversionMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockMaterial);
        Supplier convertedItemProvider = (Supplier)ModItems.MATERIAL_TO_ITEM_CONVERSIONS.getOrDefault(conversionMaterial, ModItems.MATERIAL_TO_ITEM_CONVERSIONS.get(Material.field_151576_e));
        ChiseledBlockItem chiseledBlockItem = (ChiseledBlockItem)convertedItemProvider.get();
        return new SingleBlockMultiStateItemStack((Item)chiseledBlockItem, ChunkSectionUtils.cloneSection(this.lazyChunkSection));
    }

    @Override
    public IMultiStateObjectStatistics getStatics() {
        this.load();
        this.buildStatistics();
        return this.stateObjectStatistics;
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        this.load();
        this.lazyChunkSection = ChunkSectionUtils.rotate90Degrees(this.lazyChunkSection, axis, rotationCount);
        this.lazyNbtCompound = ChunkSectionUtils.serializeNBT(this.lazyChunkSection);
        this.buildStatistics();
    }

    @Override
    public void mirror(Direction.Axis axis) {
        this.load();
        this.lazyChunkSection = ChunkSectionUtils.mirror(this.lazyChunkSection, axis);
        this.lazyNbtCompound = ChunkSectionUtils.serializeNBT(this.lazyChunkSection);
        this.buildStatistics();
    }

    private void buildStatistics() {
        this.stateObjectStatistics = new IMultiStateObjectStatistics(){

            @Override
            public BlockState getPrimaryState() {
                return LazilyDecodingSingleBlockMultiStateSnapshot.this.determinePrimaryState();
            }

            @Override
            public Map<BlockState, Integer> getStateCounts() {
                return LazilyDecodingSingleBlockMultiStateSnapshot.this.stream().collect(Collectors.toMap(IStateEntryInfo::getState, s -> 1, Integer::sum));
            }

            @Override
            public boolean shouldCheckWeakPower() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getFullnessFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getSlipperiness() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightEmissionFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getRelativeBlockHardness(PlayerEntity player) {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canPropagateSkylight() {
                throw new NotImplementedException("Is a snapshot");
            }
        };
    }

    private BlockState determinePrimaryState() {
        HashMap countMap = Maps.newHashMap();
        this.load();
        this.lazyChunkSection.func_186049_g().func_225497_a(countMap::put);
        BlockState maxState = Blocks.field_150350_a.func_176223_P();
        int maxCount = 0;
        for (Map.Entry blockStateIntegerEntry : countMap.entrySet()) {
            if (maxCount >= (Integer)blockStateIntegerEntry.getValue()) continue;
            maxState = (BlockState)blockStateIntegerEntry.getKey();
            maxCount = (Integer)blockStateIntegerEntry.getValue();
        }
        return maxState;
    }

    @Override
    public IMultiStateSnapshot clone() {
        this.load();
        return new LazilyDecodingSingleBlockMultiStateSnapshot(ChunkSectionUtils.serializeNBT(this.lazyChunkSection));
    }

    private static class Identifier
    implements IAreaShapeIdentifier {
        private final long[] identifyingPayload;

        private Identifier(ChunkSection section) {
            this.identifyingPayload = Arrays.copyOf(section.func_186049_g().field_186021_b.func_188143_a(), section.func_186049_g().field_186021_b.func_188143_a().length);
        }

        public int hashCode() {
            return Arrays.hashCode(this.identifyingPayload);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return Arrays.equals(this.identifyingPayload, that.identifyingPayload);
        }
    }

    private static class StateEntry
    implements IMutableStateEntryInfo {
        private final BlockState blockState;
        private final Vector3d startPoint;
        private final Vector3d endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        private StateEntry(BlockState blockState, Vector3i startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockState = blockState;
            this.startPoint = Vector3d.func_237491_b_((Vector3i)startPoint).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.endPoint = Vector3d.func_237491_b_((Vector3i)startPoint).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).func_72441_c((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        public BlockState getState() {
            return this.blockState;
        }

        @Override
        public Vector3d getStartPoint() {
            return this.startPoint;
        }

        @Override
        public Vector3d getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setState(BlockState blockState) throws SpaceOccupiedException {
            this.stateSetter.accept(blockState, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }
    }
}

