/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.voxelshape;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.voxelshape.VoxelShapeCalculator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoxelShapeManager
implements IVoxelShapeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final VoxelShapeManager INSTANCE = new VoxelShapeManager();
    private final Cache<Key, VoxelShape> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    private VoxelShapeManager() {
    }

    public static VoxelShapeManager getInstance() {
        return INSTANCE;
    }

    @Override
    public VoxelShape get(IAreaAccessor accessor, BlockPos offset, Function<IAreaAccessor, Predicate<IStateEntryInfo>> selectablePredicateBuilder, boolean simplify) {
        try {
            Key cacheKey = new Key(accessor.createNewShapeIdentifier(), offset, selectablePredicateBuilder.apply(accessor), simplify);
            return (VoxelShape)this.cache.get((Object)cacheKey, () -> {
                VoxelShape calculatedShape = VoxelShapeCalculator.calculate(accessor, offset, selectablePredicateBuilder, simplify);
                if (calculatedShape.func_197766_b()) {
                    return VoxelShapes.func_197880_a();
                }
                return calculatedShape;
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to calculate voxelshape.", (Throwable)e);
            return VoxelShapes.func_197880_a();
        }
    }

    @Override
    public Optional<VoxelShape> getCached(IAreaShapeIdentifier identifier, BlockPos offset, Predicate<IStateEntryInfo> selectablePredicate, boolean simplify) {
        Key key = new Key(identifier, offset, selectablePredicate, simplify);
        return Optional.ofNullable(this.cache.getIfPresent((Object)key));
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final BlockPos offset;
        private final Predicate<IStateEntryInfo> predicate;
        private final boolean simplify;

        private Key(IAreaShapeIdentifier identifier, BlockPos offset, Predicate<IStateEntryInfo> predicate, boolean simplify) {
            this.identifier = identifier;
            this.offset = offset;
            this.predicate = predicate;
            this.simplify = simplify;
        }

        public String toString() {
            return "Key{identifier=" + this.identifier.toString() + ", offset=" + this.offset + ", predicate=" + this.predicate + ", simplify=" + this.simplify + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.simplify != key.simplify) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.offset, key.offset)) {
                return false;
            }
            return Objects.equals(this.predicate, key.predicate);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
            result = 31 * result + (this.simplify ? 1 : 0);
            return result;
        }
    }
}

