/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.blocks;

import com.cgessinger.creaturesandbeasts.common.entites.LizardEntity;
import com.cgessinger.creaturesandbeasts.common.init.ModBlockRegistry;
import com.cgessinger.creaturesandbeasts.common.init.ModEntityTypes;
import com.cgessinger.creaturesandbeasts.common.init.ModItems;
import com.cgessinger.creaturesandbeasts.common.init.ModSoundEventTypes;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LizardEggBlock
extends Block {
    private static final VoxelShape THREE_EGG_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)12.0, (double)2.0, (double)12.0);
    public static final IntegerProperty EGGS = ModBlockRegistry.EGGS_1_6;
    public static final IntegerProperty VARIANT_0 = IntegerProperty.func_177719_a((String)"variant_0", (int)0, (int)3);
    public static final IntegerProperty VARIANT_1 = IntegerProperty.func_177719_a((String)"variant_1", (int)0, (int)3);

    public LizardEggBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151566_D, (MaterialColor)MaterialColor.field_151658_d).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e).harvestLevel(1).func_200944_c().func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)EGGS, (Comparable)Integer.valueOf(6))).func_206870_a((Property)VARIANT_0, (Comparable)Integer.valueOf(0))).func_206870_a((Property)VARIANT_1, (Comparable)Integer.valueOf(2)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{EGGS, VARIANT_0, VARIANT_1});
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.canGrow((World)worldIn)) {
            this.removeOneEgg((World)worldIn, pos, state);
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            LizardEntity lizard = (LizardEntity)((EntityType)ModEntityTypes.LIZARD.get()).func_200721_a((World)worldIn);
            lizard.func_70873_a(-24000);
            lizard.setVariant(lizard.func_70681_au().nextBoolean() ? ((Integer)state.func_177229_b((Property)VARIANT_0)).intValue() : ((Integer)state.func_177229_b((Property)VARIANT_1)).intValue());
            lizard.func_70012_b((double)pos.func_177958_n() + 0.3, pos.func_177956_o(), (double)pos.func_177952_p() + 0.3, 0.0f, 0.0f);
            worldIn.func_217376_c((Entity)lizard);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return THREE_EGG_SHAPE;
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        for (int i = 0; i < (Integer)state.func_177229_b((Property)EGGS); ++i) {
            LizardEggBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModItems.LIZARD_EGG.get()));
        }
    }

    private boolean canGrow(World worldIn) {
        float f = worldIn.func_242415_f(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return worldIn.field_73012_v.nextInt(200) == 0;
    }

    private void removeOneEgg(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_184133_a(null, pos, (SoundEvent)ModSoundEventTypes.LIZARD_EGG_HATCH.get(), SoundCategory.BLOCKS, 1.0f, 0.0f);
        int i = (Integer)state.func_177229_b((Property)EGGS);
        if (i <= 1) {
            worldIn.func_175655_b(pos, false);
        } else {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
    }
}

