/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.ItemIc2ca;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import com.zuxelus.comboarmors.utils.TankFluidHandlerItemStack;
import ic2.core.IC2;
import ic2.core.block.BlockFoam;
import ic2.core.block.BlockIC2Fence;
import ic2.core.block.BlockScaffold;
import ic2.core.block.state.IIdProvider;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemExoFoamSprayer
extends ItemIc2ca {
    private static final int CAPACITY = 8000;

    public ItemExoFoamSprayer() {
        this.func_77637_a(ComboArmors.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.upgrade_module_installed", (Object[])new Object[0]));
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            tooltip.add("< " + fs.getLocalizedName() + ", " + fs.amount + "/" + this.getCapacity(stack) + " mB >");
        } else {
            tooltip.add(I18n.func_135052_a((String)"ic2.item.FluidContainer.Empty", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack(ModItems.exoFoamSprayer));
        ItemStack stack = new ItemStack(ModItems.exoFoamSprayer);
        this.fillTank(stack);
        items.add((Object)stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            ItemStack stack = StackUtil.get((EntityPlayer)player, (EnumHand)hand);
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
            int mode = nbtData.func_74762_e("mode");
            mode = mode == 0 ? 1 : 0;
            nbtData.func_74768_a("mode", mode);
            String sMode = mode == 0 ? "ic2.tooltip.mode.normal" : "ic2.tooltip.mode.single";
            IC2.platform.messagePlayer(player, "ic2.tooltip.mode", new Object[]{sMode});
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        ItemStack pack;
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            return EnumActionResult.PASS;
        }
        if (!IC2.platform.isSimulating()) {
            return EnumActionResult.SUCCESS;
        }
        RayTraceResult rtResult = this.func_77621_a(world, player, true);
        if (rtResult == null) {
            return EnumActionResult.PASS;
        }
        if (rtResult.field_72313_a == RayTraceResult.Type.BLOCK && !pos.equals((Object)rtResult.func_178782_a()) && LiquidUtil.drainBlockToContainer((World)world, (BlockPos)rtResult.func_178782_a(), (EntityPlayer)player, (EnumHand)hand)) {
            return EnumActionResult.SUCCESS;
        }
        int maxFoamBlocks = 0;
        ItemStack stack = StackUtil.get((EntityPlayer)player, (EnumHand)hand);
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid != null && fluid.amount > 0) {
            maxFoamBlocks += fluid.amount / this.getFluidPerFoam();
        }
        if (!((pack = (ItemStack)player.field_71071_by.field_70460_b.get(2)).func_190926_b() || pack.func_77973_b() != ItemName.cf_pack.getInstance() && pack.func_77973_b() != ModItems.exoCFPack)) {
            fluid = FluidUtil.getFluidContained((ItemStack)pack);
            if (fluid != null && fluid.amount > 0) {
                maxFoamBlocks += fluid.amount / this.getFluidPerFoam();
            } else {
                pack = null;
            }
        } else {
            pack = null;
        }
        if (maxFoamBlocks == 0) {
            return EnumActionResult.FAIL;
        }
        maxFoamBlocks = Math.min(maxFoamBlocks, this.getMaxFoamBlocks(stack));
        Target target = Target.Any;
        if (ItemExoFoamSprayer.canPlaceFoam(world, pos, Target.Scaffold)) {
            target = Target.Scaffold;
        } else if (ItemExoFoamSprayer.canPlaceFoam(world, pos, Target.Cable)) {
            target = Target.Cable;
        } else {
            pos = pos.func_177972_a(side);
        }
        Vec3d viewVec = player.func_70040_Z();
        EnumFacing playerViewFacing = EnumFacing.func_176737_a((float)((float)viewVec.field_72450_a), (float)((float)viewVec.field_72448_b), (float)((float)viewVec.field_72449_c));
        int amount = this.sprayFoam(world, pos, playerViewFacing.func_176734_d(), target, maxFoamBlocks);
        if ((amount *= this.getFluidPerFoam()) > 0) {
            if (pack != null) {
                IFluidHandlerItem packHandler = FluidUtil.getFluidHandler((ItemStack)pack);
                assert (packHandler != null);
                fluid = packHandler.drain(amount, true);
                amount -= fluid.amount;
                player.field_71071_by.field_70460_b.set(2, (Object)packHandler.getContainer());
            }
            if (amount > 0) {
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
                assert (handler != null);
                handler.drain(amount, true);
                StackUtil.set((EntityPlayer)player, (EnumHand)hand, (ItemStack)handler.getContainer());
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private int sprayFoam(World world, BlockPos pos, EnumFacing excludedDir, Target target, int maxFoamBlocks) {
        BlockPos cPos;
        if (!ItemExoFoamSprayer.canPlaceFoam(world, pos, target)) {
            return 0;
        }
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        toCheck.add(pos);
        while ((cPos = (BlockPos)toCheck.poll()) != null && positions.size() < maxFoamBlocks) {
            if (!ItemExoFoamSprayer.canPlaceFoam(world, cPos, target) || !positions.add(cPos)) continue;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == excludedDir) continue;
                toCheck.add(cPos.func_177972_a(dir));
            }
        }
        toCheck.clear();
        int failedPlacements = 0;
        block7: for (BlockPos targetPos : positions) {
            IBlockState state = world.func_180495_p(targetPos);
            Block targetBlock = state.func_177230_c();
            if (targetBlock == BlockName.scaffold.getInstance()) {
                BlockScaffold scaffold = (BlockScaffold)targetBlock;
                switch ((BlockScaffold.ScaffoldType)state.func_177229_b((IProperty)scaffold.getTypeProperty())) {
                    case wood: 
                    case reinforced_wood: {
                        scaffold.func_176226_b(world, targetPos, state, 0);
                        world.func_175656_a(targetPos, BlockName.foam.getBlockState((IIdProvider)BlockFoam.FoamType.normal));
                        continue block7;
                    }
                    case reinforced_iron: {
                        StackUtil.dropAsEntity((World)world, (BlockPos)targetPos, (ItemStack)BlockName.fence.getItemStack((Enum)BlockIC2Fence.IC2FenceType.iron));
                    }
                    case iron: {
                        world.func_175656_a(targetPos, BlockName.foam.getBlockState((IIdProvider)BlockFoam.FoamType.reinforced));
                        continue block7;
                    }
                }
                continue;
            }
            if (targetBlock == BlockName.te.getInstance()) {
                TileEntity te = world.func_175625_s(targetPos);
                if (!(te instanceof TileEntityCable) || ((TileEntityCable)te).foam()) continue;
                ++failedPlacements;
                continue;
            }
            if (world.func_175656_a(targetPos, BlockName.foam.getBlockState((IIdProvider)BlockFoam.FoamType.normal))) continue;
            ++failedPlacements;
        }
        return positions.size() - failedPlacements;
    }

    private int getMaxFoamBlocks(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (nbtData.func_74762_e("mode") == 0) {
            return 10;
        }
        return 1;
    }

    private int getFluidPerFoam() {
        return 100;
    }

    private static boolean canPlaceFoam(World world, BlockPos pos, Target target) {
        switch (target) {
            case Any: {
                return BlockName.foam.getInstance().func_176198_a(world, pos, EnumFacing.DOWN);
            }
            case Scaffold: {
                return world.func_180495_p(pos).func_177230_c() == BlockName.scaffold.getInstance();
            }
            case Cable: {
                if (world.func_180495_p(pos).func_177230_c() != BlockName.te.getInstance()) {
                    return false;
                }
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityCable) {
                    return !((TileEntityCable)te).isFoamed();
                }
                return false;
            }
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TankFluidHandlerItemStack(stack, 8000);
    }

    protected void fillTank(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = tag.func_74775_l("Fluid");
        FluidStack fs = new FluidStack(FluidRegistry.getFluid((String)"ic2construction_foam"), this.getCapacity(stack));
        fs.writeToNBT(fluidTag);
        tag.func_74782_a("Fluid", (NBTBase)fluidTag);
    }

    protected double getCharge(ItemStack stack) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs == null) {
            return 0.0;
        }
        double ret = fs.amount;
        return ret > 0.0 ? ret : 0.0;
    }

    public int getCapacity(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        if (tag.func_74764_b("addCapacity")) {
            return 8000 + tag.func_74762_e("addCapacity");
        }
        tag.func_74768_a("addCapacity", 0);
        return 8000;
    }

    static enum Target {
        Any,
        Scaffold,
        Cable;

    }
}

