/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.entities.EntityTechArrow;
import com.zuxelus.comboarmors.items.IItemUpgradeable;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNanoBow
extends ItemBow
implements IElectricItem,
IItemUpgradeable {
    static final int NORMAL = 1;
    static final int RAPID = 2;
    static final int SPREAD = 3;
    static final int SNIPER = 4;
    static final int FLAME = 5;
    static final int EXPLOSIVE = 6;
    static final int[] CHARGE = new int[]{300, 150, 400, 1000, 200, 800};
    static final String[] MODE = new String[]{"normal", "rapidfire", "spread", "sniper", "flame", "explosive"};

    public ItemNanoBow() {
        this.func_77656_e(27);
        this.setNoRepair();
        this.func_77664_n();
        this.func_77637_a(ComboArmors.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        if (!nbt.func_74767_n("loaded")) {
            if (nbt.func_74762_e("tier") == 0) {
                nbt.func_74768_a("tier", item.getTier(stack));
            }
            if (nbt.func_74769_h("transferLimit") == 0.0) {
                nbt.func_74780_a("transferLimit", item.getTransferLimit(stack));
            }
            if (nbt.func_74769_h("maxCharge") == 0.0) {
                nbt.func_74780_a("maxCharge", item.getMaxCharge(stack));
            }
            nbt.func_74757_a("loaded", true);
        }
        if (nbt.func_74769_h("transferLimit") != item.getTransferLimit(stack)) {
            tooltip.add(String.format(I18n.func_135052_a((String)"info.transferspeed", (Object[])new Object[0]), nbt.func_74769_h("transferLimit")));
        }
        if (nbt.func_74762_e("tier") != item.getTier(stack)) {
            tooltip.add(String.format(I18n.func_135052_a((String)"info.chargingtier", (Object[])new Object[0]), nbt.func_74762_e("tier")));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)charged);
        items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public int func_77619_b() {
        return 0;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        float f;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        EntityPlayer player = (EntityPlayer)entity;
        int charge = this.func_77626_a(stack) - timeLeft;
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)charge, (boolean)true)) < 0) {
            return;
        }
        if (mode == 4 || mode == 6) {
            charge /= 2;
        }
        if (mode == 2) {
            charge *= 4;
        }
        if ((double)(f = ItemNanoBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.field_72995_K) {
            int j;
            EntityTechArrow arrow = new EntityTechArrow(world, (EntityLivingBase)player);
            arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
            if (f == 1.5f) {
                arrow.func_70243_d(true);
            }
            if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (mode == 1 && arrow.func_70241_g()) {
                j += 3;
            } else if (mode == 2 && arrow.func_70241_g()) {
                ++j;
            } else if (mode == 4 && arrow.func_70241_g()) {
                j += 8;
            }
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (ComboArmors.config.nanoBowBoost > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)ComboArmors.config.nanoBowBoost * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            if (mode == 1 && arrow.func_70241_g()) {
                ++k;
            } else if (mode == 4 && arrow.func_70241_g()) {
                k += 5;
            }
            if (k > 0) {
                arrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                arrow.func_70015_d(100);
            }
            if (mode == 5 && arrow.func_70241_g()) {
                arrow.func_70015_d(2000);
            }
            if (mode == 6 && arrow.func_70241_g()) {
                arrow.setExplosive(true);
            }
            arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            switch (mode) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    ElectricItem.manager.use(stack, (double)CHARGE[mode - 1], (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    break;
                }
                case 3: {
                    ElectricItem.manager.use(stack, 350.0, (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    if (!arrow.func_70241_g()) break;
                    EntityTechArrow arrow2 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow2.func_184547_a((Entity)player, player.field_70125_A + 2.0f, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    arrow2.func_70243_d(true);
                    arrow2.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow3 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow3.func_184547_a((Entity)player, player.field_70125_A - 2.0f, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    arrow3.func_70243_d(true);
                    arrow3.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow4 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow4.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z + 2.0f, 0.0f, f * 3.0f, 1.0f);
                    arrow4.func_70243_d(true);
                    arrow4.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    EntityTechArrow arrow5 = new EntityTechArrow(world, (EntityLivingBase)player);
                    arrow5.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z - 2.0f, 0.0f, f * 3.0f, 1.0f);
                    arrow5.func_70243_d(true);
                    arrow5.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    world.func_72838_d((Entity)arrow2);
                    world.func_72838_d((Entity)arrow3);
                    world.func_72838_d((Entity)arrow4);
                    world.func_72838_d((Entity)arrow5);
                }
            }
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        player.func_71029_a(StatList.func_188057_b((Item)this));
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.5f ? 1.5f : f;
    }

    public int func_77626_a(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        switch (nbt.func_74762_e("bowMode")) {
            case 4: 
            case 6: {
                return 144000;
            }
            case 2: {
                return 18000;
            }
        }
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ActionResult result = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)true);
        if (result != null) {
            return result;
        }
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (IC2.keyboard.isModeSwitchKeyDown(player) && nbt.func_74771_c("toggleTimer") == 0) {
            if (!world.field_72995_K) {
                byte toggle = 10;
                nbt.func_74774_a("toggleTimer", toggle);
                if (++mode == 2 && !ComboArmors.config.rapidFireMode) {
                    ++mode;
                }
                if (mode == 3 && !ComboArmors.config.spreadMode) {
                    ++mode;
                }
                if (mode == 4 && !ComboArmors.config.sniperMode) {
                    ++mode;
                }
                if (mode == 5 && !ComboArmors.config.flameMode) {
                    ++mode;
                }
                if (mode == 6 && !ComboArmors.config.explosiveMode) {
                    ++mode;
                }
                if (mode > 6) {
                    mode -= 6;
                }
                nbt.func_74768_a("bowMode", mode);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nanobow." + MODE[mode - 1], new Object[0]));
            }
        } else if (player.field_71075_bZ.field_75098_d || ElectricItem.manager.canUse(stack, (double)CHARGE[mode - 1])) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int mode;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        byte toggle = nbt.func_74771_c("toggleTimer");
        if (toggle > 0) {
            toggle = (byte)(toggle - 1);
            nbt.func_74774_a("toggleTimer", toggle);
        }
        if ((mode = nbt.func_74762_e("bowMode")) == 0) {
            nbt.func_74768_a("bowMode", 1);
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int j;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 2 && (j = this.func_77626_a(stack) - count) >= 10 && ElectricItem.manager.canUse(stack, (double)CHARGE[1])) {
            player.func_184597_cx();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74769_h("maxCharge") == 0.0) {
            nbt.func_74780_a("maxCharge", (double)this.getDefaultMaxCharge());
        }
        return nbt.func_74769_h("maxCharge");
    }

    public int getTier(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74762_e("tier") == 0) {
            nbt.func_74768_a("tier", this.getDefaultTier());
        }
        return nbt.func_74762_e("tier");
    }

    public double getTransferLimit(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74769_h("transferLimit") == 0.0) {
            nbt.func_74780_a("transferLimit", (double)this.getDefaultTransferLimit());
        }
        return nbt.func_74769_h("transferLimit");
    }

    @Override
    public int getDefaultMaxCharge() {
        return 40000;
    }

    @Override
    public int getDefaultTier() {
        return 2;
    }

    @Override
    public int getDefaultTransferLimit() {
        return 128;
    }

    @Override
    public int getItemTier() {
        return 3;
    }

    @Override
    public int getMaxUpgradeableCharge() {
        return ComboArmors.config.maxEnergyUpgrades - this.getDefaultMaxCharge();
    }

    @Override
    public int getMaxUpgradeableTransfer() {
        return ComboArmors.config.maxTransferUpgrades - this.getDefaultTransferLimit();
    }
}

