/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.util.BiomeUtil;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class ItemArmorBase
extends ItemArmor {
    private static boolean lastJetpackUsed = false;
    private static AudioSource audioSource;

    public ItemArmorBase(EntityEquipmentSlot slot) {
        super(ItemArmor.ArmorMaterial.DIAMOND, -1, slot);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(ComboArmors.creativeTab);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    protected void playAudioSource(EntityPlayer player, boolean jetpackUsed) {
        if (!IC2.platform.isRendering() || player != IC2.platform.getPlayerInstance()) {
            return;
        }
        if (lastJetpackUsed != jetpackUsed) {
            if (jetpackUsed) {
                if (audioSource == null) {
                    audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                }
                if (audioSource != null) {
                    audioSource.play();
                }
            } else if (audioSource != null) {
                audioSource.remove();
                audioSource = null;
            }
            lastJetpackUsed = jetpackUsed;
        }
        if (audioSource != null) {
            audioSource.updatePosition();
        }
    }

    protected static boolean onHelmetSolarTick(EntityPlayer player, ItemStack stack) {
        double chargeAmount = ItemArmorBase.getSkyLight(player.func_130014_f_(), player.func_180425_c());
        if (chargeAmount == 0.0) {
            return false;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        double prod = nbt.func_74762_e("solarProd") > 0 ? (double)(nbt.func_74762_e("solarProd") + 1) * chargeAmount : chargeAmount;
        boolean result = false;
        if (ItemArmorBase.tryChargeSolar(player, ComboArmors.config.soPriority[0], prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeSolar(player, ComboArmors.config.soPriority[1], prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeSolar(player, ComboArmors.config.soPriority[2], prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeSolar(player, ComboArmors.config.soPriority[3], prod)) {
            result = true;
        }
        return result;
    }

    private static float getSkyLight(World world, BlockPos pos) {
        if (world.field_73011_w.func_177495_o()) {
            return 0.0f;
        }
        float sunBrightness = Util.limit((float)((float)Math.cos(world.func_72929_e(1.0f)) * 2.0f + 0.2f), (float)0.0f, (float)1.0f);
        if (!BiomeDictionary.hasType((Biome)BiomeUtil.getBiome((World)world, (BlockPos)pos), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            sunBrightness *= 1.0f - world.func_72867_j(1.0f) * 5.0f / 16.0f;
            sunBrightness *= 1.0f - world.func_72819_i(1.0f) * 5.0f / 16.0f;
            sunBrightness = Util.limit((float)sunBrightness, (float)0.0f, (float)1.0f);
        }
        return (float)world.func_175642_b(EnumSkyBlock.SKY, pos) / 15.0f * sunBrightness;
    }

    private static boolean tryChargeSolar(EntityPlayer player, int slot, double prod) {
        if (((ItemStack)player.field_71071_by.field_70460_b.get(slot)).func_190926_b()) {
            return false;
        }
        return ElectricItem.manager.charge((ItemStack)player.field_71071_by.field_70460_b.get(slot), prod, Integer.MAX_VALUE, true, false) > 0.0;
    }

    protected static boolean doStatic(EntityPlayer player, ItemStack stack) {
        double distance;
        boolean isNotWalking;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int prod = nbt.func_74762_e("staticProd");
        boolean bl = isNotWalking = player.func_184187_bx() != null || player.func_70090_H();
        if (!nbt.func_74764_b("x") || isNotWalking) {
            nbt.func_74768_a("x", (int)player.field_70165_t);
        }
        if (!nbt.func_74764_b("z") || isNotWalking) {
            nbt.func_74768_a("z", (int)player.field_70161_v);
        }
        if ((distance = Math.sqrt(((double)nbt.func_74762_e("x") - player.field_70165_t) * ((double)nbt.func_74762_e("x") - player.field_70165_t) + ((double)nbt.func_74762_e("z") - player.field_70161_v) * ((double)nbt.func_74762_e("z") - player.field_70161_v))) < 5.0) {
            return false;
        }
        nbt.func_74768_a("x", (int)player.field_70165_t);
        nbt.func_74768_a("z", (int)player.field_70161_v);
        boolean result = false;
        NonNullList armor = player.field_71071_by.field_70460_b;
        if (ItemArmorBase.tryChargeStatic((NonNullList<ItemStack>)armor, ComboArmors.config.stPriority[0], distance, prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeStatic((NonNullList<ItemStack>)armor, ComboArmors.config.stPriority[1], distance, prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeStatic((NonNullList<ItemStack>)armor, ComboArmors.config.stPriority[2], distance, prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeStatic((NonNullList<ItemStack>)armor, ComboArmors.config.stPriority[3], distance, prod)) {
            result = true;
        }
        return result;
    }

    private static boolean tryChargeStatic(NonNullList<ItemStack> armor, int slot, double distance, int prod) {
        if (((ItemStack)armor.get(slot)).func_190926_b() || !(((ItemStack)armor.get(slot)).func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        return ElectricItem.manager.charge((ItemStack)armor.get(slot), (double)(Math.min(3, (int)distance / 5) + prod), Integer.MAX_VALUE, true, false) > 0.0;
    }
}

