/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.items.IItemUpgradeable;
import com.zuxelus.comboarmors.items.armor.ItemArmorBase;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.HudMode;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.item.ItemTinCan;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemArmorElectricUtility
extends ItemArmorBase
implements ISpecialArmor,
IElectricItem,
IItemUpgradeable {
    public int defaultMaxCharge;
    public int transferLimit;
    public int tier;
    public boolean shareEnergy;
    private float jumpCharge;
    private static final Map<Potion, Integer> potionRemovalCost = new HashMap<Potion, Integer>();

    public ItemArmorElectricUtility(EntityEquipmentSlot slot, int maxCharge, int transferLimit, int tier, boolean shareEnergy) {
        super(slot);
        this.tier = tier;
        this.defaultMaxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.shareEnergy = shareEnergy;
        this.func_77656_e(27);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (!nbt.func_74767_n("loaded")) {
            if (nbt.func_74762_e("tier") == 0) {
                nbt.func_74768_a("tier", this.getDefaultTier());
            }
            if (nbt.func_74762_e("transferLimit") == 0) {
                nbt.func_74768_a("transferLimit", this.getDefaultTransferLimit());
            }
            if (nbt.func_74762_e("maxCharge") == 0) {
                nbt.func_74768_a("maxCharge", this.getDefaultMaxCharge());
            }
            nbt.func_74757_a("loaded", true);
        }
        tooltip.add(I18n.func_135052_a((String)"info.upgrade_module_installed", (Object[])new Object[0]));
        if (nbt.func_74767_n("flight")) {
            tooltip.add(I18n.func_135052_a((String)"info.flight_turbine_installed", (Object[])new Object[0]));
        }
        if (nbt.func_74767_n("cloaking")) {
            tooltip.add(I18n.func_135052_a((String)"info.cloaking_module_installed", (Object[])new Object[0]));
        }
        if (nbt.func_74767_n("isCloakActive")) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"info.cloaking_module_active", (Object[])new Object[0]));
        }
        if (nbt.func_74767_n("overcharge")) {
            tooltip.add(I18n.func_135052_a((String)"info.discharge_module_installed", (Object[])new Object[0]));
        }
        if (nbt.func_74762_e("solarProd") > 0) {
            tooltip.add(I18n.func_135052_a((String)"info.solar_produces", (Object[])new Object[]{nbt.func_74762_e("solarProd") + 1}));
        }
        if (nbt.func_74762_e("staticProd") > 0) {
            tooltip.add(I18n.func_135052_a((String)"info.static_produces", (Object[])new Object[]{nbt.func_74762_e("staticProd") + 1}));
        }
        if (nbt.func_74762_e("transferLimit") != this.getDefaultTransferLimit()) {
            tooltip.add(I18n.func_135052_a((String)"info.transfer_speed", (Object[])new Object[]{nbt.func_74762_e("transferLimit")}));
        }
        tooltip.add(I18n.func_135052_a((String)"info.power_tier", (Object[])new Object[]{nbt.func_74762_e("tier")}));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)charged);
        items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    private double getBaseAbsorptionRatio() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 0.15;
            }
            case CHEST: {
                return 0.4;
            }
            case LEGS: {
                return 0.3;
            }
            case FEET: {
                return 0.15;
            }
        }
        return 0.0;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    public static double getCharge(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack);
    }

    public static void discharge(ItemStack stack, double amount) {
        ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
    }

    private boolean useQuantumJetpack(EntityPlayer player, boolean hoverMode, boolean hoverModeQ, boolean boost) {
        double consume;
        int worldHeight;
        float y;
        float retruster;
        float forwardpower;
        ItemStack jetpack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (ItemArmorElectricUtility.getCharge(jetpack) == 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if (ItemArmorElectricUtility.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (ItemArmorElectricUtility.getCharge(jetpack) / this.getMaxCharge(jetpack) * (double)dropPercentage));
        }
        if (IC2.keyboard.isForwardKeyDown(player) && (forwardpower = power * (retruster = hoverModeQ ? 0.5f : (hoverMode ? 1.0f : 3.5f)) * 2.0f) > 0.0f) {
            if (boost) {
                player.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.1f);
            } else {
                player.func_191958_b(0.0f, 0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        if ((y = (float)player.field_70163_u) > (float)((worldHeight = IC2.getWorldHeight((World)player.func_130014_f_())) - 25)) {
            if (y > (float)worldHeight) {
                y = worldHeight;
            }
            power = power * ((float)worldHeight - y) / 25.0f;
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode || hoverModeQ) {
            float maxHoverY;
            float f = maxHoverY = hoverModeQ ? -0.025f : 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                float f2 = maxHoverY = hoverModeQ ? 0.1f : 0.2f;
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                float f3 = maxHoverY = hoverModeQ ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double d = consume = hoverMode || hoverModeQ ? (double)ComboArmors.config.jetpackEUAmount * 1.25 : (double)ComboArmors.config.jetpackEUAmount;
        if (boost) {
            consume += (double)ComboArmors.config.turbineEUAmount;
        }
        ItemArmorElectricUtility.discharge(jetpack, consume);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    protected void onFall(LivingFallEvent event, boolean isQuantum) {
        if (!IC2.platform.isSimulating() || !(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        ItemStack armor = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (!armor.func_190926_b() && armor.func_77973_b() == this) {
            int fallDamage;
            int distance = (int)event.getDistance();
            int n = fallDamage = isQuantum ? Math.max(distance - 10, 0) : distance - 3;
            if (!isQuantum && fallDamage >= 8) {
                return;
            }
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ItemArmorElectricUtility.discharge(armor, energyCost);
                event.setCanceled(true);
            }
        }
    }

    protected boolean onQuantumJetpackTick(EntityPlayer player, NBTTagCompound nbtData) {
        if (nbtData.func_74767_n("isFlyActive")) {
            return false;
        }
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (!nbtData.func_74764_b("jetpack")) {
            nbtData.func_74757_a("jetpack", true);
        }
        boolean jetpack = nbtData.func_74767_n("jetpack");
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        boolean hoverModeQ = nbtData.func_74767_n("hoverModeQ");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            if (!hoverMode && !hoverModeQ) {
                boolean bl = hoverModeQ = !hoverModeQ;
                if (IC2.platform.isSimulating()) {
                    nbtData.func_74757_a("hoverModeQ", hoverModeQ);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.quantum_hover_mode_enabled", new Object[0]));
                }
            } else if (!hoverMode && hoverModeQ) {
                hoverMode = !hoverMode;
                boolean bl = hoverModeQ = !hoverModeQ;
                if (IC2.platform.isSimulating()) {
                    nbtData.func_74757_a("hoverMode", hoverMode);
                    nbtData.func_74757_a("hoverModeQ", hoverModeQ);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.hover_mode_enabled", new Object[0]));
                }
            } else {
                hoverMode = false;
                hoverModeQ = false;
                if (IC2.platform.isSimulating()) {
                    nbtData.func_74757_a("hoverMode", hoverMode);
                    nbtData.func_74757_a("hoverModeQ", hoverModeQ);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.hover_mode_disabled", new Object[0]));
                }
            }
        }
        if (IC2.keyboard.isBoostKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = jetpack = !jetpack;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("jetpack", jetpack);
                if (jetpack) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.jetpack_enabled", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.jetpack_disabled", new Object[0]));
                }
            }
        }
        if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode || hoverModeQ && player.field_70181_x < -0.02999999932944775)) {
            jetpackUsed = this.useQuantumJetpack(player, hoverMode, hoverModeQ, nbtData.func_74767_n("isFlyActive"));
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        this.playAudioSource(player, jetpackUsed);
        player.func_70066_B();
        return jetpackUsed;
    }

    protected boolean onQuantumBootsTick(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbtData = ItemNBTHelper.getOrCreateNbtData(stack);
        boolean flag = false;
        if (IC2.platform.isSimulating()) {
            boolean wasOnGround;
            boolean bl = wasOnGround = nbtData.func_74764_b("wasOnGround") ? nbtData.func_74767_n("wasOnGround") : true;
            if (wasOnGround && !player.field_70122_E && IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                ElectricItem.manager.use(stack, 4000.0, null);
                flag = true;
            }
            if (player.field_70122_E != wasOnGround) {
                nbtData.func_74757_a("wasOnGround", player.field_70122_E);
            }
        } else {
            if (ElectricItem.manager.canUse(stack, 4000.0) && player.field_70122_E) {
                this.jumpCharge = 1.0f;
            }
            if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                    if (this.jumpCharge == 1.0f) {
                        player.field_70159_w *= 3.5;
                        player.field_70179_y *= 3.5;
                    }
                    player.field_70181_x += (double)(this.jumpCharge * 0.3f);
                    this.jumpCharge *= 0.75f;
                } else if (this.jumpCharge < 1.0f) {
                    this.jumpCharge = 0.0f;
                }
            }
        }
        return flag;
    }

    protected static boolean onHelmetTick(EntityPlayer player, ItemStack stack) {
        boolean result = false;
        int air = player.func_70086_ai();
        if (ElectricItem.manager.canUse(stack, 1000.0) && air < 100) {
            player.func_70050_g(air + 200);
            ElectricItem.manager.use(stack, 1000.0, null);
            result = true;
        } else if (air <= 0) {
            IC2.achievements.issueAchievement(player, "starveWithQHelmet");
        }
        if (ElectricItem.manager.canUse(stack, 1000.0) && player.func_71024_bL().func_75121_c()) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack can = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (can.func_190926_b() || !can.func_77969_a(ComboArmors.ic2.getItemStack("filledTinCan"))) continue;
                ActionResult res = ((ItemTinCan)can.func_77973_b()).onEaten(player, can);
                if ((can = (ItemStack)res.func_188398_b()).func_190926_b()) {
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
                if (res.func_188397_a() == EnumActionResult.SUCCESS) {
                    ElectricItem.manager.use(stack, 1000.0, null);
                }
                result = true;
                break;
            }
        } else if (player.func_71024_bL().func_75116_a() <= 0) {
            IC2.achievements.issueAchievement(player, "starveWithQHelmet");
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            Potion potion = effect.func_188419_a();
            Integer cost = potionRemovalCost.get(potion);
            if (cost == null || !ElectricItem.manager.canUse(stack, (double)(cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
            ElectricItem.manager.use(stack, (double)cost.intValue(), null);
            IC2.platform.removePotion((EntityLivingBase)player, potion);
        }
        return result;
    }

    protected static boolean onNightvisionTick(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData((ItemStack)stack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean Nightvision = nbtData.func_74767_n("Nightvision");
        if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = Nightvision = !Nightvision;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("Nightvision", Nightvision);
                if (Nightvision) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nightvision_enabled", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nightvision_disabled", new Object[0]));
                }
            }
        }
        int hubmode = nbtData.func_74762_e("HudMode");
        if (IC2.keyboard.isAltKeyDown(player) && IC2.keyboard.isHudModeKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            int n = hubmode = hubmode == HudMode.getMaxMode() ? 0 : hubmode + 1;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74768_a("HudMode", hubmode);
                player.func_145747_a((ITextComponent)new TextComponentTranslation(HudMode.getFromID((int)hubmode).getTranslationKey(), new Object[0]));
            }
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        boolean result = false;
        if (Nightvision && IC2.platform.isSimulating() && ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
            BlockPos pos = new BlockPos((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
            int skylight = player.func_130014_f_().func_175671_l(pos);
            if (skylight > 8) {
                IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76439_r);
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, true));
            } else {
                IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, true));
            }
            result = true;
        }
        return result;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack stack, int slot) {
        if (ElectricItem.manager.getCharge(stack) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return this.shareEnergy;
    }

    public double getMaxCharge(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74762_e("maxCharge") == 0) {
            nbt.func_74768_a("maxCharge", this.getDefaultMaxCharge());
        }
        return nbt.func_74762_e("maxCharge");
    }

    public int getTier(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74762_e("tier") == 0) {
            nbt.func_74768_a("tier", this.getDefaultTier());
        }
        return nbt.func_74762_e("tier");
    }

    public double getTransferLimit(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74762_e("transferLimit") == 0) {
            nbt.func_74768_a("transferLimit", this.getDefaultTransferLimit());
        }
        return nbt.func_74762_e("transferLimit");
    }

    @Override
    public int getDefaultMaxCharge() {
        return this.defaultMaxCharge;
    }

    @Override
    public int getDefaultTier() {
        return this.tier;
    }

    @Override
    public int getDefaultTransferLimit() {
        return this.transferLimit;
    }

    @Override
    public int getMaxUpgradeableCharge() {
        return ComboArmors.config.maxEnergyUpgrades - this.getDefaultMaxCharge();
    }

    @Override
    public int getMaxUpgradeableTransfer() {
        return ComboArmors.config.maxTransferUpgrades - this.getDefaultTransferLimit();
    }

    static {
        potionRemovalCost.put(MobEffects.field_76436_u, 10000);
        potionRemovalCost.put((Potion)IC2Potion.radiation, 10000);
        potionRemovalCost.put(MobEffects.field_82731_v, 25000);
    }
}

