/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.items.armor.ItemArmorBase;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import com.zuxelus.comboarmors.utils.TankFluidHandlerItemStack;
import ic2.core.util.Util;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemArmorTankUtility
extends ItemArmorBase
implements ISpecialArmor {
    protected final int capacity;
    protected final Fluid allowfluid;

    public ItemArmorTankUtility(EntityEquipmentSlot slot, Fluid allowfluid, int capacity) {
        super(slot);
        this.capacity = capacity;
        this.allowfluid = allowfluid;
        this.func_77656_e(27);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            tooltip.add("< " + fs.getLocalizedName() + ", " + fs.amount + "/" + this.getCapacity(stack) + " mB >");
        } else {
            tooltip.add(I18n.func_135052_a((String)"ic2.item.FluidContainer.Empty", (Object[])new Object[0]));
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    protected void fillTank(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = tag.func_74775_l("Fluid");
        FluidStack fs = new FluidStack(this.allowfluid, this.getCapacity(stack));
        fs.writeToNBT(fluidTag);
        tag.func_74782_a("Fluid", (NBTBase)fluidTag);
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TankFluidHandlerItemStack(stack, this.capacity);
    }

    protected double getCharge(ItemStack stack) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs == null) {
            return 0.0;
        }
        double ret = fs.amount;
        return ret > 0.0 ? ret : 0.0;
    }

    public int getCapacity(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        if (tag.func_74764_b("addCapacity")) {
            return this.capacity + tag.func_74762_e("addCapacity");
        }
        tag.func_74768_a("addCapacity", 0);
        return this.capacity;
    }

    public void updateDamage(ItemStack stack) {
        stack.func_77964_b(stack.func_77958_k() - 1 - (int)Util.map((double)this.getCharge(stack), (double)this.getCapacity(stack), (double)(stack.func_77958_k() - 2)));
    }
}

