/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.recipes;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.items.IItemUpgradeable;
import com.zuxelus.comboarmors.recipes.RecipeHandler;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ArmorAssemblerRecipes {
    private static List<Recipe> recipes = new ArrayList<Recipe>();
    private static List<Item> items = new ArrayList<Item>();

    public static List<Recipe> getRecipeList() {
        return recipes;
    }

    public static void addAssemblyRecipe(ItemStack result, ItemStack input1, Item input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(result.func_77946_l(), input1.func_77946_l(), new ItemStack(input2));
    }

    public static void addAssemblyRecipe(Item result, Item input1, ItemStack input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(new ItemStack(result), new ItemStack(input1), input2.func_77946_l());
    }

    public static void addAssemblyRecipe(Item result, ItemStack input1, Item input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(new ItemStack(result), input1.func_77946_l(), new ItemStack(input2));
    }

    public static void addAssemblyRecipe(Item result, Item input1, Item input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(new ItemStack(result), new ItemStack(input1), new ItemStack(input2));
    }

    public static void addAssemblyRecipe(ItemStack result, ItemStack input1, ItemStack input2) {
        ArmorAssemblerRecipes.addRecipe(result, input1, input2);
        if (!items.contains(input1.func_77973_b())) {
            items.add(input1.func_77973_b());
        }
        if (!items.contains(input2.func_77973_b())) {
            items.add(input2.func_77973_b());
        }
    }

    private static void addRecipe(ItemStack result, ItemStack input1, ItemStack input2) {
        if (result.func_190926_b()) {
            throw new NullPointerException("The recipe output is null");
        }
        if (input1.func_190926_b()) {
            throw new NullPointerException("The recipe input 1 is null");
        }
        if (input2.func_190926_b()) {
            throw new NullPointerException("The recipe input 2 is null");
        }
        InventoryBasic inv = new InventoryBasic(null, false, 2);
        ItemStack output = result.func_77946_l();
        inv.func_70299_a(0, input1.func_77946_l());
        inv.func_70299_a(1, input2.func_77946_l());
        RecipeHandler.onCrafting(output, (IInventory)inv);
        recipes.add(new Recipe(input1, input2, output));
        recipes.add(new Recipe(input2, input1, output));
    }

    public static List<Item> getItemList() {
        return items;
    }

    public static ItemStack getAssemblyResult(ItemStack input1, ItemStack input2) {
        if (input1.func_190926_b() || input2.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (Recipe recipe : recipes) {
            if (!recipe.matches(input1, input2) || !ArmorAssemblerRecipes.checkRecipe(input1, input2, recipe.output)) continue;
            return recipe.output;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean checkRecipe(ItemStack input1, ItemStack input2, ItemStack output) {
        if (output.func_77973_b() instanceof IElectricItem && output.func_77973_b() instanceof IItemUpgradeable) {
            NBTTagCompound nbt;
            if (input1.func_77969_a(ComboArmors.ic2.getItemStack("transformerUpgrade")) && input2.func_77973_b() instanceof IElectricItem && input2.func_77973_b() instanceof IItemUpgradeable && (nbt = ItemNBTHelper.getOrCreateNbtData(input2)).func_74762_e("tier") == 1) {
                return false;
            }
            if (input2.func_77969_a(ComboArmors.ic2.getItemStack("transformerUpgrade")) && input1.func_77973_b() instanceof IElectricItem && input1.func_77973_b() instanceof IItemUpgradeable && (nbt = ItemNBTHelper.getOrCreateNbtData(input1)).func_74762_e("tier") == 1) {
                return false;
            }
        }
        return true;
    }

    public static class Recipe {
        public final ItemStack input1;
        public final ItemStack input2;
        public final ItemStack output;

        public Recipe(ItemStack input1, ItemStack input2, ItemStack output) {
            this.input1 = input1;
            this.input2 = input2;
            this.output = output;
        }

        public boolean matches(ItemStack i1, ItemStack i2) {
            return this.input1.func_77973_b() == i1.func_77973_b() && this.input2.func_77973_b() == i2.func_77973_b();
        }
    }
}

