/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.tileentities;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.blocks.BlockArmorAssembler;
import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.IItemUpgrade;
import com.zuxelus.comboarmors.items.IItemUpgradeable;
import com.zuxelus.comboarmors.items.ItemUpgrade;
import com.zuxelus.comboarmors.items.armor.ItemArmorTankUtility;
import com.zuxelus.comboarmors.recipes.ArmorAssemblerRecipes;
import com.zuxelus.comboarmors.recipes.RecipeHandler;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import com.zuxelus.zlib.tileentities.TileEntityEnergySink;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityArmorAssembler
extends TileEntityEnergySink
implements ITickable {
    public static final int SLOT_INPUT1 = 0;
    public static final int SLOT_INPUT2 = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_UPGRADE = 3;
    public static final int SLOT_DISCHARGER = 4;
    public static final int TIER = 3;
    public static final int CAPACITY = 50000;
    public static final int OUTPUT = 512;
    public static final int CONSUMPTION = 32;
    public static final int TIMEFACTOR = 14;
    private int production;
    private int productionMax;
    private boolean active;

    public TileEntityArmorAssembler() {
        super("tile.armor_assembler.name", 3, 512, 50000);
        this.addedToEnet = false;
        this.active = false;
        this.production = 0;
        this.productionMax = 0;
    }

    public int getProduction() {
        return this.production;
    }

    public int getProductionFactor() {
        if (this.productionMax == 0) {
            return 0;
        }
        return Math.round(this.production / this.productionMax * 24);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTimeString() {
        int hours;
        int seconds;
        if (this.productionMax <= 0) {
            return I18n.func_135052_a((String)"info.remaining", (Object[])new Object[]{"0:00:00"});
        }
        int mtime = this.productionMax / 280;
        int time = this.production / 280;
        int timeleft = mtime - time;
        int minutes = timeleft / 60;
        String s = (seconds = timeleft - ((minutes -= (hours = minutes / 60) * 60) * 60 + hours * 3600)) < 10 ? ":0" : ":";
        String s2 = minutes < 10 ? ":0" : ":";
        return I18n.func_135052_a((String)"info.remaining", (Object[])new Object[]{"" + hours + s2 + minutes + s + seconds});
    }

    public boolean getActive() {
        return this.active;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("energy") || !tag.func_74764_b("production")) break;
                this.energy = tag.func_74769_h("energy");
                this.production = tag.func_74762_e("production");
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        tag.func_74757_a("active", this.active);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.updateActive();
        tag.func_74757_a("active", this.active);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("production")) {
            this.production = tag.func_74762_e("production");
        }
        if (tag.func_74764_b("productionMax")) {
            this.productionMax = tag.func_74762_e("productionMax");
        }
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("production", this.production);
        tag.func_74768_a("productionMax", this.productionMax);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    @Override
    public void onLoad() {
        if (!this.addedToEnet && this.field_145850_b != null && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
            this.updateActive();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.onLoad();
        this.handleDischarger(4);
        ItemStack stack = this.func_70301_a(3);
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.creativeUpgrade && this.productionMax > 0) {
            this.combineItem();
            this.production = 0;
            this.updateState();
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.energy >= 32.0) {
            this.energy -= 32.0;
            this.production += 14;
            if (this.production >= this.productionMax) {
                this.combineItem();
                this.production = 0;
                this.updateState();
            }
        } else {
            this.energy = 0.0;
            this.production = 0;
            this.updateState();
        }
    }

    public void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateState();
    }

    private void updateActive() {
        this.active = false;
        this.updateMaxProgress();
        if (this.energy < 32.0) {
            return;
        }
        this.active = this.canCombine();
    }

    private void updateState() {
        boolean old = this.active;
        int oldProductionMax = this.productionMax;
        this.updateActive();
        if (this.active != old) {
            this.production = 0;
            IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            Block block = iblockstate.func_177230_c();
            if (!(block instanceof BlockArmorAssembler) || (Boolean)iblockstate.func_177229_b((IProperty)BlockArmorAssembler.ACTIVE) == this.active) {
                return;
            }
            IBlockState newState = block.func_176223_P().func_177226_a((IProperty)BlockArmorAssembler.field_185512_D, iblockstate.func_177229_b((IProperty)BlockArmorAssembler.field_185512_D)).func_177226_a((IProperty)BlockArmorAssembler.ACTIVE, (Comparable)Boolean.valueOf(this.active));
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            return;
        }
        if (oldProductionMax != this.productionMax) {
            this.notifyBlockUpdate();
        }
    }

    private boolean canCombine() {
        ItemStack input1 = this.func_70301_a(0);
        ItemStack input2 = this.func_70301_a(1);
        if (input1.func_190926_b() || input2.func_190926_b()) {
            return false;
        }
        ItemStack result = ArmorAssemblerRecipes.getAssemblyResult(input1, input2);
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = this.func_70301_a(2);
        return output.func_190926_b();
    }

    private void combineItem() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.canCombine()) {
            return;
        }
        ItemStack input1 = this.func_70301_a(0);
        ItemStack input2 = this.func_70301_a(1);
        ItemStack result = ArmorAssemblerRecipes.getAssemblyResult(input1, input2);
        ItemStack output = result.func_77946_l();
        RecipeHandler.onCrafting(output, (IInventory)this);
        if (output.func_77973_b() instanceof IElectricItem) {
            int charge = 0;
            NBTTagCompound nbtout = ItemNBTHelper.getOrCreateNbtData(output);
            NBTTagCompound nbtin1 = ItemNBTHelper.getOrCreateNbtData(input1);
            NBTTagCompound nbtin2 = ItemNBTHelper.getOrCreateNbtData(input2);
            charge += nbtin1.func_74762_e("charge");
            if ((charge += nbtin2.func_74762_e("charge")) > nbtout.func_74762_e("maxCharge")) {
                charge = nbtout.func_74762_e("maxCharge");
            }
            nbtout.func_74768_a("charge", charge);
            RecipeHandler.updateElectricDamageBars(output);
        }
        this.func_70299_a(2, output);
        input1.func_190918_g(1);
        if (input1.func_190916_E() <= 0) {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
        input2.func_190918_g(1);
        if (input2.func_190916_E() <= 0) {
            this.func_70299_a(1, ItemStack.field_190927_a);
        }
    }

    private void updateMaxProgress() {
        IItemUpgradeable item;
        ItemStack input2;
        ItemStack input1 = this.func_70301_a(0);
        ItemStack result = ArmorAssemblerRecipes.getAssemblyResult(input1, input2 = this.func_70301_a(1));
        if (result.func_190926_b()) {
            this.productionMax = 0;
            return;
        }
        int upgradeSlot = -1;
        if (input1.func_77973_b() instanceof IItemUpgrade || input1.func_77969_a(ComboArmors.ic2.getItemStack("overclockerUpgrade")) || input1.func_77969_a(ComboArmors.ic2.getItemStack("energyStorageUpgrade")) || input1.func_77969_a(ComboArmors.ic2.getItemStack("transformerUpgrade"))) {
            upgradeSlot = 1;
        }
        if (input2.func_77973_b() instanceof IItemUpgrade || input2.func_77969_a(ComboArmors.ic2.getItemStack("overclockerUpgrade")) || input2.func_77969_a(ComboArmors.ic2.getItemStack("energyStorageUpgrade")) || input2.func_77969_a(ComboArmors.ic2.getItemStack("transformerUpgrade"))) {
            upgradeSlot = 2;
        }
        if (upgradeSlot == -1) {
            item = (IItemUpgradeable)result.func_77973_b();
            int tier = item.getItemTier();
            int mins = tier * 10;
            int secs = mins * 60;
            int ticks = secs * 20;
            this.productionMax = ticks * 14;
        } else if (result.func_77973_b() instanceof IItemUpgradeable) {
            item = (IItemUpgradeable)result.func_77973_b();
            int modifier = 1;
            if (upgradeSlot == 1 && input1.func_77973_b() instanceof ItemUpgrade) {
                modifier = ((ItemUpgrade)input1.func_77973_b()).getStackModifier(input1);
            }
            if (upgradeSlot == 2 && input2.func_77973_b() instanceof ItemUpgrade) {
                modifier = ((ItemUpgrade)input2.func_77973_b()).getStackModifier(input2);
            }
            int tier = item.getItemTier();
            int mins = tier * 5;
            int secs = mins * 60;
            int ticks = secs * 20;
            int eu = ticks * 14;
            int num = 0;
            if (upgradeSlot == 1) {
                num = input1.func_190916_E() * modifier;
            }
            if (upgradeSlot == 2) {
                num = input2.func_190916_E() * modifier;
            }
            double min = (double)num * 1.875;
            double sec = min * 60.0;
            double tick = sec * 20.0;
            int eu2 = (int)tick * 14;
            this.productionMax = eu + eu2;
        } else if (result.func_77973_b() instanceof ItemArmorTankUtility) {
            this.productionMax = 252000;
        }
        ItemStack upgrade = this.func_70301_a(3);
        if (!upgrade.func_190926_b() && upgrade.func_77973_b() == ModItems.overclockerUpgrade) {
            this.productionMax /= upgrade.func_190916_E() + 1;
        }
    }

    public int func_70302_i_() {
        return 5;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 0: 
            case 1: {
                return ArmorAssemblerRecipes.getItemList().contains(stack.func_77973_b());
            }
            case 3: {
                return stack.func_77973_b() == ModItems.overclockerUpgrade || stack.func_77973_b() == ModItems.creativeUpgrade;
            }
            case 4: {
                return ElectricItem.manager.discharge(stack, Double.POSITIVE_INFINITY, this.tier, true, true, true) > 0.0;
            }
        }
        return false;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double old = this.energy;
        this.energy += amount;
        double left = 0.0;
        if (this.energy > this.capacity) {
            left = this.energy - this.capacity;
            this.energy = this.capacity;
        }
        if (this.energy > 0.0 && old == 0.0 && !this.field_145850_b.field_72995_K) {
            this.updateState();
        }
        return left;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

