/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.zlib.tileentities;

import com.zuxelus.zlib.tileentities.TileEntityFacing;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityInventory
extends TileEntityFacing
implements ISidedInventory {
    protected NonNullList<ItemStack> inventory;
    protected String customName;

    public TileEntityInventory(String name) {
        this.customName = name;
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            this.inventory.set((int)stackTag.func_74771_c("Slot"), (Object)new ItemStack(stackTag));
        }
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        NBTTagList list = new NBTTagList();
        for (byte i = 0; i < this.func_70302_i_(); i = (byte)((byte)(i + 1))) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", i);
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        return tag;
    }

    public String func_70005_c_() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.func_70302_i_() ? (ItemStack)this.inventory.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(slot, (Object)ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public List<ItemStack> getDrops(int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        return list;
    }

    public void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        List<ItemStack> list = this.getDrops(1);
        for (ItemStack stack : list) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i()));
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            stack.func_190920_e(0);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }
}

