/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.config.ConfigHandler;
import com.zuxelus.comboarmors.items.armor.IJetpack;
import com.zuxelus.comboarmors.utils.InvisiblePotionEffect;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S39PacketPlayerAbilities;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class ServerTickHandler {
    public static List<EntityPlayer> cloakingList = new ArrayList<EntityPlayer>();
    public static List<EntityPlayer> flyList = new ArrayList<EntityPlayer>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        NBTTagCompound tag;
        block21: {
            block20: {
                if (event.phase != TickEvent.Phase.START) break block20;
                Side cfr_ignored_0 = event.side;
                if (event.side == Side.SERVER) break block21;
            }
            return;
        }
        if (!(event.player instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = event.player;
        ItemStack armor = player.field_71071_by.func_70440_f(2);
        if (flyList.contains(player)) {
            if (armor != null && armor.func_77973_b() instanceof IJetpack) {
                tag = ItemNBTHelper.getOrCreateNbtData(armor);
                if (tag.func_74767_n("flight") && tag.func_74767_n("isFlyActive")) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (tag.func_74762_e("charge") < 10) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("Out of energy!", new Object[0]));
                            ServerTickHandler.disableFlyMode(player, tag);
                        } else if (player.field_71075_bZ.field_75100_b) {
                            ElectricItem.manager.discharge(armor, (double)ConfigHandler.turbineEUAmount, 4, true, false, false);
                        }
                    }
                    player.field_70143_R = 0.0f;
                    if (player.field_70163_u > 262.0 && !player.field_71075_bZ.field_75098_d) {
                        player.func_70107_b(player.field_70165_t, 262.0, player.field_70161_v);
                    }
                }
            } else {
                ServerTickHandler.disableFlyMode(player, new NBTTagCompound());
            }
        }
        if (cloakingList.contains(player)) {
            if (armor != null && ComboArmors.chests.contains(armor.func_77977_a())) {
                tag = ItemNBTHelper.getOrCreateNbtData(armor);
                if (tag.func_74767_n("cloaking") && tag.func_74767_n("isCloakActive") && !player.field_71075_bZ.field_75098_d) {
                    if (tag.func_74762_e("charge") < 10) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.out_of_energy", new Object[0]));
                        ServerTickHandler.disableCloakMode(player, tag);
                    } else {
                        ElectricItem.manager.discharge(armor, 10.0, 4, true, false, false);
                    }
                }
            } else {
                ServerTickHandler.disableCloakMode(player, new NBTTagCompound());
            }
        }
    }

    public static void onPlayerLogin(EntityPlayer player) {
        ItemStack armor = player.field_71071_by.func_70440_f(2);
        if (armor == null) {
            return;
        }
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(armor);
        if (!player.func_82150_aj() && armor != null && ComboArmors.chests.contains(armor.func_77977_a()) && tag.func_74767_n("cloaking") && tag.func_74767_n("isCloakActive")) {
            ServerTickHandler.enableCloakMode(player, tag);
        }
        if (armor != null && armor.func_77973_b() instanceof IJetpack && tag.func_74767_n("flight") && tag.func_74767_n("isFlyActive")) {
            ServerTickHandler.enableFlyMode(player, tag);
        }
    }

    public static boolean switchCloakMode(EntityPlayer player) {
        ItemStack armor = player.field_71071_by.func_70440_f(2);
        if (armor == null || !ComboArmors.chests.contains(armor.func_77977_a())) {
            return false;
        }
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(armor);
        if (!tag.func_74767_n("cloaking")) {
            return false;
        }
        if (tag.func_74767_n("isCloakActive")) {
            ServerTickHandler.disableCloakMode(player, tag);
            return false;
        }
        if (tag.func_74762_e("charge") < 10 && !player.field_71075_bZ.field_75098_d) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.not_enough_energy_cloaking", new Object[0]));
            return false;
        }
        if (player.func_82150_aj()) {
            return false;
        }
        ServerTickHandler.enableCloakMode(player, tag);
        return true;
    }

    public static void disableCloakMode(EntityPlayer player, NBTTagCompound tag) {
        player.func_82170_o(Potion.field_76441_p.field_76415_H);
        tag.func_74757_a("isCloakActive", false);
        cloakingList.remove(player);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.cloaking_module_disabled", new Object[0]));
    }

    public static void enableCloakMode(EntityPlayer player, NBTTagCompound tag) {
        player.func_70690_d((PotionEffect)new InvisiblePotionEffect());
        tag.func_74757_a("isCloakActive", true);
        cloakingList.add(player);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.cloaking_module_enabled", new Object[0]));
    }

    public static void switchFlyMode(EntityPlayer player) {
        ItemStack armor = player.field_71071_by.func_70440_f(2);
        if (armor == null || !(armor.func_77973_b() instanceof IJetpack)) {
            return;
        }
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(armor);
        if (tag.func_74767_n("flight")) {
            if (tag.func_74767_n("isFlyActive")) {
                ServerTickHandler.disableFlyMode(player, tag);
            } else if (tag.func_74762_e("charge") < 10 && !player.field_71075_bZ.field_75098_d) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.not_enough_energy_flight", new Object[0]));
            } else {
                ServerTickHandler.enableFlyMode(player, tag);
            }
        }
    }

    public static void disableFlyMode(EntityPlayer player, NBTTagCompound tag) {
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S39PacketPlayerAbilities(player.field_71075_bZ));
        }
        tag.func_74757_a("isFlyActive", false);
        flyList.remove(player);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.flight_mode_disabled", new Object[0]));
    }

    public static void enableFlyMode(EntityPlayer player, NBTTagCompound tag) {
        player.field_71075_bZ.field_75101_c = true;
        player.field_71075_bZ.field_75100_b = true;
        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S39PacketPlayerAbilities(player.field_71075_bZ));
        tag.func_74757_a("isFlyActive", true);
        flyList.add(player);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.flight_mode_enabled", new Object[0]));
    }
}

