/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.config;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.init.CrossModLoader;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public Configuration config;
    public static int[] soPriority = new int[4];
    public static int[] stPriority = new int[4];
    public static int maxProdUpgrades;
    public static int maxEnergyUpgrades;
    public static int maxTransferUpgrades;
    public static int nanoBowBoost;
    public static int turbineEUAmount;
    public static int jetpackEUAmount;
    public static boolean craftSolarProd;
    public static boolean craftStaticProd;
    public static boolean craftFlightTurbine;
    public static boolean craftCloakingModule;
    public static boolean craftDischargeModule;
    public static boolean craftCellModule;
    public static boolean craftEnergyMk2;
    public static boolean craftEnergyMk3;
    public static boolean useEnergyMk1;
    public static boolean useOverclocker;
    public static boolean useTransformer;
    public static boolean craftNanoBow;
    public static boolean rapidFireMode;
    public static boolean spreadMode;
    public static boolean sniperMode;
    public static boolean flameMode;
    public static boolean explosiveMode;

    public void init(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
        }
        this.loadConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        String CATEGORY_CROSSMOD = "cross-mod";
        String CATEGORY_GENERAL = "general";
        try {
            Property enableCSolars = this.config.get("cross-mod", "cs-enable", true);
            enableCSolars.comment = "Disable Compact Solars integration, regardless of whether or not the mod is found.";
            CrossModLoader.setIntegrationEnabled(0, enableCSolars.getBoolean(true));
            Property enableASolars = this.config.get("cross-mod", "asp-enable", true);
            enableASolars.comment = "Disabled Advanced Solar Panels integration, regardless of whether or not the mod is found.";
            CrossModLoader.setIntegrationEnabled(1, enableASolars.getBoolean(true));
            Property soPriority1Prop = this.config.get("general", "solarPriority1", 2);
            soPriority1Prop.comment = "Set the charging priority for the Solar Helmets and Static Boots. Use numbers 0-3, where 0 is the boots. Default order: 2, 0, 1, 3";
            ConfigHandler.soPriority[0] = soPriority1Prop.getInt();
            ConfigHandler.soPriority[1] = this.config.get("general", "solarPriority2", 0).getInt();
            ConfigHandler.soPriority[2] = this.config.get("general", "solarPriority3", 1).getInt();
            ConfigHandler.soPriority[3] = this.config.get("general", "solarPriority4", 3).getInt();
            ConfigHandler.stPriority[0] = this.config.get("general", "staticPriority1", 2).getInt();
            ConfigHandler.stPriority[1] = this.config.get("general", "staticPriority2", 0).getInt();
            ConfigHandler.stPriority[2] = this.config.get("general", "staticPriority3", 1).getInt();
            ConfigHandler.stPriority[3] = this.config.get("general", "staticPriority4", 3).getInt();
            turbineEUAmount = this.config.get("general", "euUsageTurbine", 10).getInt();
            Property jetpackTurbine = this.config.get("general", "euUsageJetpack", 8);
            jetpackTurbine.comment = "Change the EU Usage of Jetpacks and Turbines. Hover mode uses 25% less than the value below.";
            jetpackEUAmount = jetpackTurbine.getInt(8);
            Property maxProdUpgradesProp = this.config.get("general", "maxProductionUpgrades", 511);
            maxProdUpgradesProp.comment = "Set the max number of Solar Production or Static Production upgrades to be installed in one item. Note that the max will be one more than the number you enter, as the default has 1. Default value: 511.";
            maxProdUpgrades = maxProdUpgradesProp.getInt();
            Property maxEnergyUpgradesProp = this.config.get("general", "maxEnergyUpgrades", 100000000);
            maxEnergyUpgradesProp.comment = "Set the max Energy that an upgraded item can have. Default: 100,000,000";
            maxEnergyUpgrades = maxEnergyUpgradesProp.getInt();
            Property maxTransferUpgradesProp = this.config.get("general", "maxTransferUpgrades", 200000);
            maxTransferUpgradesProp.comment = "Set the max Transfer Limit that an upgraded item can have. Default: 200,000";
            maxTransferUpgrades = maxTransferUpgradesProp.getInt();
            Property enableCraftingCloak = this.config.get("general", "enableCraftingCloakingModule", true);
            enableCraftingCloak.comment = "Enable whether or not the upgrades can be crafted. They can still be spawned in and used if you are an admin. Default: all true.";
            craftSolarProd = this.config.get("general", "enableCraftingSolarProduction", true).getBoolean(true);
            craftStaticProd = this.config.get("general", "enableCraftingStaticProduction", true).getBoolean(true);
            craftFlightTurbine = this.config.get("general", "enableCraftingFlightTurbine", true).getBoolean(true);
            craftCloakingModule = enableCraftingCloak.getBoolean(true);
            craftDischargeModule = this.config.get("general", "enableCraftingDischargeModule", true).getBoolean(true);
            craftCellModule = this.config.get("general", "enableCraftingCellModule", true).getBoolean(true);
            craftEnergyMk2 = this.config.get("general", "enableCraftingEnergyMk2", true).getBoolean(true);
            craftEnergyMk3 = this.config.get("general", "enableCraftingEnergyMk3", true).getBoolean(true);
            craftNanoBow = this.config.get("general", "enableCraftingNanoBow", true).getBoolean(true);
            useEnergyMk1 = this.config.get("general", "enableUseEnergyMk1", true).getBoolean(true);
            useOverclocker = this.config.get("general", "enableUseOverclocker", true).getBoolean(true);
            useTransformer = this.config.get("general", "enableUseTransformer", true).getBoolean(true);
            Property nanoboost = this.config.get("general", "nanoBowDamageBoost", 0);
            nanoboost.comment = "Boost the damage of the NanoBow, for use with things like Divine RPG. Each number adds 1 level of the Power enchantment.";
            nanoBowBoost = nanoboost.getInt();
            Property nanoBowMods = this.config.get("general", "bowExplosiveMode", true);
            nanoBowMods.comment = "Enabled NanoBow modes { \"Normal\", \"Rapid fire\", \"Spread\", \"Sniper\", \"Flame\", \"Explosive\" }";
            explosiveMode = nanoBowMods.getBoolean(true);
            flameMode = this.config.get("general", "bowFlameMode", true).getBoolean(true);
            rapidFireMode = this.config.get("general", "bowRapidFireMode", true).getBoolean(true);
            sniperMode = this.config.get("general", "bowSniperMode", true).getBoolean(true);
            spreadMode = this.config.get("general", "bowSpreadMode", true).getBoolean(true);
        }
        catch (Exception e) {
            ComboArmors.logger.error("Mod has a problem loading it's configuration", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("comboarmors")) {
            this.loadConfiguration();
        }
    }
}

