/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.init;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.EnumUpgradeType;
import com.zuxelus.comboarmors.items.ItemUpgrade;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;

public class CrossModLoader {
    public static final int COMPACT_SOLARS = 0;
    public static final int ADVANCED_SOLAR_PANELS = 1;
    public static final int GRAVISUITE = 2;
    public static final int GREGTECH = 3;
    public static final String[] modids = new String[]{"CompactSolars", "AdvancedSolarPanel"};
    private static boolean[] loaded = new boolean[]{false, false, false, false};
    private static boolean[] integrateEnabled = new boolean[]{true, true, true, true};

    private static void integrateCompactSolars() {
        ModItems.lvHat = GameRegistry.findItem((String)modids[0], (String)"solarHatLV");
        ModItems.mvHat = GameRegistry.findItem((String)modids[0], (String)"solarHatMV");
        ModItems.hvHat = GameRegistry.findItem((String)modids[0], (String)"solarHatHV");
        ModItems.lvArray = new ItemStack(GameRegistry.findBlock((String)modids[0], (String)"CompactSolarBlock"), 1, 0);
        ModItems.mvArray = new ItemStack(GameRegistry.findBlock((String)modids[0], (String)"CompactSolarBlock"), 1, 1);
        ModItems.hvArray = new ItemStack(GameRegistry.findBlock((String)modids[0], (String)"CompactSolarBlock"), 1, 2);
        ModItems.lvSolarModule = ModItems.register(new ItemUpgrade(EnumRarity.common, EnumUpgradeType.SOLARS), "lv_solar_module");
        ModItems.mvSolarModule = ModItems.register(new ItemUpgrade(EnumRarity.common, EnumUpgradeType.SOLARS), "mv_solar_module");
        ModItems.hvSolarModule = ModItems.register(new ItemUpgrade(EnumRarity.common, EnumUpgradeType.SOLARS), "hv_solar_module");
    }

    private static void integrateAdvancedSolars() {
        ModItems.asp = new ItemStack(GameRegistry.findBlock((String)modids[1], (String)"BlockAdvSolarPanel"), 1, 0);
        ModItems.hybridsp = new ItemStack(GameRegistry.findBlock((String)modids[1], (String)"BlockAdvSolarPanel"), 1, 1);
        ModItems.ulthybsp = new ItemStack(GameRegistry.findBlock((String)modids[1], (String)"BlockAdvSolarPanel"), 1, 2);
        ModItems.ash = new ItemStack(GameRegistry.findItem((String)modids[1], (String)"advanced_solar_helmet"));
        ModItems.hsh = new ItemStack(GameRegistry.findItem((String)modids[1], (String)"hybrid_solar_helmet"));
        ModItems.uhsh = new ItemStack(GameRegistry.findItem((String)modids[1], (String)"ultimate_solar_helmet"));
        if (!loaded[0]) {
            ModItems.lvSolarModule = ModItems.register(new ItemUpgrade(EnumRarity.common, EnumUpgradeType.SOLARS), "lv_solar_module");
            ModItems.mvSolarModule = ModItems.register(new ItemUpgrade(EnumRarity.common, EnumUpgradeType.SOLARS), "mv_solar_module");
            ModItems.hvSolarModule = ModItems.register(new ItemUpgrade(EnumRarity.common, EnumUpgradeType.SOLARS), "hv_solar_module");
        }
    }

    public static void integrateMod(int i) {
        switch (i) {
            case 0: {
                CrossModLoader.integrateCompactSolars();
                break;
            }
            case 1: {
                CrossModLoader.integrateAdvancedSolars();
                break;
            }
        }
    }

    public static boolean isModLoaded(int i) {
        return loaded[i];
    }

    public static void loadIntegrationModules() {
        ComboArmors.logger.info("Loading Cross-Mod Integration Modules");
        int l = modids.length;
        for (int i = 0; i < l; ++i) {
            String modid = modids[i];
            if (!integrateEnabled[i]) {
                ComboArmors.logger.info("Integration of " + modid + " has been disabled in the configs. Skipping.");
                continue;
            }
            if (Loader.isModLoaded((String)modid)) {
                CrossModLoader.integrateMod(i);
                CrossModLoader.loaded[i] = true;
                ComboArmors.logger.info("Successfully loaded integration for " + modid + ".");
                continue;
            }
            ComboArmors.logger.info("Failed to load integration for " + modid + ".");
        }
    }

    public static void setIntegrationEnabled(int i, boolean b) {
        CrossModLoader.integrateEnabled[i] = b;
    }
}

