/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.config.ConfigHandler;
import com.zuxelus.comboarmors.entities.EntityTechArrow;
import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.IItemUpgradeable;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import com.zuxelus.comboarmors.utils.Util;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemNanoBow
extends ItemBow
implements IElectricItem,
IItemUpgradeable {
    static final int NORMAL = 1;
    static final int RAPID = 2;
    static final int SPREAD = 3;
    static final int SNIPER = 4;
    static final int FLAME = 5;
    static final int EXPLOSIVE = 6;
    static final int[] CHARGE = new int[]{300, 150, 400, 1000, 200, 800};
    static final String[] MODE = new String[]{"normal", "rapidfire", "spread", "sniper", "flame", "explosive"};
    public IIcon[] icons;

    public ItemNanoBow() {
        this.func_77656_e(27);
        this.func_77664_n();
        this.func_77637_a(ComboArmors.creativeTab);
        this.icons = new IIcon[4];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        if (!nbt.func_74767_n("loaded")) {
            if (nbt.func_74762_e("tier") == 0) {
                nbt.func_74768_a("tier", item.getTier(stack));
            }
            if (nbt.func_74769_h("transferLimit") == 0.0) {
                nbt.func_74780_a("transferLimit", item.getTransferLimit(stack));
            }
            if (nbt.func_74769_h("maxCharge") == 0.0) {
                nbt.func_74780_a("maxCharge", item.getMaxCharge(stack));
            }
            nbt.func_74757_a("loaded", true);
        }
        if (nbt.func_74769_h("transferLimit") != item.getTransferLimit(stack)) {
            tooltip.add(String.format(I18n.func_135052_a((String)"info.transferspeed", (Object[])new Object[0]), nbt.func_74769_h("transferLimit")));
        }
        if (nbt.func_74762_e("tier") != item.getTier(stack)) {
            tooltip.add(String.format(I18n.func_135052_a((String)"info.chargingtier", (Object[])new Object[0]), nbt.func_74762_e("tier")));
        }
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List items) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add(charged);
        items.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icons[0] = Util.register(ir, (Item)this);
        this.icons[1] = Util.register(ir, Util.getFileName((Item)this) + "_1");
        this.icons[2] = Util.register(ir, Util.getFileName((Item)this) + "_2");
        this.icons[3] = Util.register(ir, Util.getFileName((Item)this) + "_3");
        this.field_77791_bV = this.icons[0];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null && usingItem.func_77973_b() == ModItems.nanoBow) {
            NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
            int mode = nbt.func_74762_e("bowMode");
            int i1 = 18;
            int i2 = 13;
            if (mode == 4 || mode == 6) {
                i1 = 36;
                i2 = 26;
            } else if (mode == 2) {
                i1 = 5;
                i2 = 3;
            }
            int k = usingItem.func_77988_m() - useRemaining;
            if (k >= i1) {
                return this.icons[3];
            }
            if (k > i2) {
                return this.icons[2];
            }
            if (k > 0) {
                return this.icons[1];
            }
        }
        return this.icons[0];
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        float f;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        int charge = this.func_77626_a(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, charge);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        charge = event.charge;
        if (mode == 4 || mode == 6) {
            charge /= 2;
        }
        if (mode == 2) {
            charge *= 4;
        }
        if ((double)(f = ItemNanoBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.field_72995_K) {
            int j;
            EntityTechArrow arrow = new EntityTechArrow(world, (EntityLivingBase)player, f * 2.0f);
            if (f == 1.5f) {
                arrow.func_70243_d(true);
            }
            if ((j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (mode == 1 && arrow.func_70241_g()) {
                j += 3;
            } else if (mode == 2 && arrow.func_70241_g()) {
                ++j;
            } else if (mode == 4 && arrow.func_70241_g()) {
                j += 8;
            }
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (ConfigHandler.nanoBowBoost > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)ConfigHandler.nanoBowBoost * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
            if (mode == 1 && arrow.func_70241_g()) {
                ++k;
            } else if (mode == 4 && arrow.func_70241_g()) {
                k += 5;
            }
            if (k > 0) {
                arrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                arrow.func_70015_d(100);
            }
            if (mode == 5 && arrow.func_70241_g()) {
                arrow.func_70015_d(2000);
            }
            if (mode == 6 && arrow.func_70241_g()) {
                arrow.setExplosive(true);
            }
            arrow.field_70251_a = 2;
            switch (mode) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    ElectricItem.manager.use(stack, (double)CHARGE[mode - 1], (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    break;
                }
                case 3: {
                    ElectricItem.manager.use(stack, 350.0, (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                    if (!arrow.func_70241_g()) break;
                    EntityTechArrow arrow2 = new EntityTechArrow(world, (EntityLivingBase)player, f * 2.0f);
                    arrow2.func_70107_b(arrow2.field_70165_t + 0.25, arrow2.field_70163_u, arrow2.field_70161_v);
                    arrow2.func_70243_d(true);
                    arrow2.field_70251_a = 2;
                    EntityTechArrow arrow3 = new EntityTechArrow(world, (EntityLivingBase)player, f * 2.0f);
                    arrow3.func_70107_b(arrow3.field_70165_t, arrow3.field_70163_u + 0.25, arrow3.field_70161_v);
                    arrow3.func_70243_d(true);
                    arrow3.field_70251_a = 2;
                    EntityTechArrow arrow4 = new EntityTechArrow(world, (EntityLivingBase)player, f * 2.0f);
                    arrow4.func_70107_b(arrow4.field_70165_t - 0.25, arrow4.field_70163_u, arrow4.field_70161_v);
                    arrow4.func_70243_d(true);
                    arrow4.field_70251_a = 2;
                    EntityTechArrow arrow5 = new EntityTechArrow(world, (EntityLivingBase)player, f * 2.0f);
                    arrow5.func_70107_b(arrow5.field_70165_t, arrow5.field_70163_u - 0.25, arrow5.field_70161_v);
                    arrow5.func_70243_d(true);
                    arrow5.field_70251_a = 2;
                    world.func_72838_d((Entity)arrow2);
                    world.func_72838_d((Entity)arrow3);
                    world.func_72838_d((Entity)arrow4);
                    world.func_72838_d((Entity)arrow5);
                }
            }
        }
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.5f ? 1.5f : f;
    }

    public int func_77626_a(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        switch (nbt.func_74762_e("bowMode")) {
            case 4: 
            case 6: {
                return 144000;
            }
            case 2: {
                return 18000;
            }
        }
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (IC2.keyboard.isModeSwitchKeyDown(player) && nbt.func_74771_c("toggleTimer") == 0) {
            if (!world.field_72995_K) {
                byte toggle = 10;
                nbt.func_74774_a("toggleTimer", toggle);
                if (++mode == 2) {
                    if (!ConfigHandler.rapidFireMode) {
                        ++mode;
                    }
                }
                if (mode == 3) {
                    if (!ConfigHandler.spreadMode) {
                        ++mode;
                    }
                }
                if (mode == 4) {
                    if (!ConfigHandler.sniperMode) {
                        ++mode;
                    }
                }
                if (mode == 5) {
                    if (!ConfigHandler.flameMode) {
                        ++mode;
                    }
                }
                if (mode == 6) {
                    if (!ConfigHandler.explosiveMode) {
                        ++mode;
                    }
                }
                if (mode > 6) {
                    mode -= 6;
                }
                nbt.func_74768_a("bowMode", mode);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.nanobow." + MODE[mode - 1], new Object[0]));
            }
        } else if (player.field_71075_bZ.field_75098_d || ElectricItem.manager.canUse(stack, (double)CHARGE[mode - 1])) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int mode;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        byte toggle = nbt.func_74771_c("toggleTimer");
        if (toggle > 0) {
            toggle = (byte)(toggle - 1);
            nbt.func_74774_a("toggleTimer", toggle);
        }
        if ((mode = nbt.func_74762_e("bowMode")) == 0) {
            nbt.func_74768_a("bowMode", 1);
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int i) {
        int j;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 2 && (j = this.func_77626_a(stack) - i) >= 10 && ElectricItem.manager.canUse(stack, (double)CHARGE[1])) {
            player.func_71034_by();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack is) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74769_h("maxCharge") == 0.0) {
            nbt.func_74780_a("maxCharge", (double)this.getDefaultMaxCharge());
        }
        return nbt.func_74769_h("maxCharge");
    }

    public int getTier(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74762_e("tier") == 0) {
            nbt.func_74768_a("tier", this.getDefaultTier());
        }
        return nbt.func_74762_e("tier");
    }

    public double getTransferLimit(ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbt.func_74769_h("transferLimit") == 0.0) {
            nbt.func_74780_a("transferLimit", (double)this.getDefaultTransferLimit());
        }
        return nbt.func_74769_h("transferLimit");
    }

    public Item getChargedItem(ItemStack stack) {
        return stack == null ? null : stack.func_77973_b();
    }

    public Item getEmptyItem(ItemStack stack) {
        return stack == null ? null : stack.func_77973_b();
    }

    @Override
    public int getDefaultMaxCharge() {
        return 40000;
    }

    @Override
    public int getDefaultTier() {
        return 2;
    }

    @Override
    public int getDefaultTransferLimit() {
        return 128;
    }

    @Override
    public int getItemTier() {
        return 3;
    }

    @Override
    public int getMaxUpgradeableCharge() {
        return ConfigHandler.maxEnergyUpgrades - this.getDefaultMaxCharge();
    }

    @Override
    public int getMaxUpgradeableTransfer() {
        return ConfigHandler.maxTransferUpgrades - this.getDefaultTransferLimit();
    }
}

