/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.config.ConfigHandler;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import com.zuxelus.comboarmors.utils.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenDesert;

public class ItemArmorBase
extends ItemArmor {
    private static boolean lastJetpackUsed = false;
    private static AudioSource audioSource;

    public ItemArmorBase(int renderIndex, int piece) {
        super(ItemArmor.ArmorMaterial.DIAMOND, renderIndex, piece);
        this.func_77625_d(1);
        this.func_77637_a(ComboArmors.creativeTab);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = Util.register(ir, (Item)this);
    }

    protected void playAudioSource(EntityPlayer player, boolean jetpackUsed) {
        if (!IC2.platform.isRendering() || player != IC2.platform.getPlayerInstance()) {
            return;
        }
        if (lastJetpackUsed != jetpackUsed) {
            if (jetpackUsed) {
                if (audioSource == null) {
                    audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                }
                if (audioSource != null) {
                    audioSource.play();
                }
            } else if (audioSource != null) {
                audioSource.remove();
                audioSource = null;
            }
            lastJetpackUsed = jetpackUsed;
        }
        if (audioSource != null) {
            audioSource.updatePosition();
        }
    }

    protected static boolean onHelmetSolarTick(EntityPlayer player, ItemStack stack) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !ItemArmorBase.isSunVisible(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v)) {
            return false;
        }
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int prod = nbt.func_74762_e("solarProd") > 0 ? nbt.func_74762_e("solarProd") + 1 : 1;
        boolean result = false;
        if (ItemArmorBase.tryChargeSolar(player, ConfigHandler.soPriority[0], prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeSolar(player, ConfigHandler.soPriority[1], prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeSolar(player, ConfigHandler.soPriority[2], prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeSolar(player, ConfigHandler.soPriority[3], prod)) {
            result = true;
        }
        return result;
    }

    private static boolean isSunVisible(World world, int x, int y, int z) {
        return world.func_72957_l(x, 255, z) > 4 && !world.field_73011_w.field_76576_e && world.func_72937_j(x, y, z) && (world.func_72959_q().func_76935_a(x, z) instanceof BiomeGenDesert || !world.func_72896_J() && !world.func_72911_I());
    }

    private static boolean tryChargeSolar(EntityPlayer player, int slot, int prod) {
        if (player.field_71071_by.field_70460_b[slot] == null) {
            return false;
        }
        return ElectricItem.manager.charge(player.field_71071_by.field_70460_b[slot], (double)prod, Integer.MAX_VALUE, true, false) > 0.0;
    }

    protected void flyKeyPressed(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        if (!nbt.func_74764_b("jetpack")) {
            nbt.func_74757_a("jetpack", true);
        }
        nbt.func_74757_a("jetpack", !nbt.func_74767_n("jetpack"));
        if (IC2.platform.isSimulating()) {
            if (nbt.func_74767_n("jetpack")) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.jetpack_enabled", new Object[0]));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.jetpack_disabled", new Object[0]));
            }
        }
    }

    protected static boolean doStatic(EntityPlayer player, ItemStack stack) {
        double distance;
        boolean isNotWalking;
        NBTTagCompound nbt = ItemNBTHelper.getOrCreateNbtData(stack);
        int prod = nbt.func_74762_e("staticProd");
        boolean bl = isNotWalking = player.field_70154_o != null || player.func_70090_H();
        if (!nbt.func_74764_b("x") || isNotWalking) {
            nbt.func_74768_a("x", (int)player.field_70165_t);
        }
        if (!nbt.func_74764_b("z") || isNotWalking) {
            nbt.func_74768_a("z", (int)player.field_70161_v);
        }
        if ((distance = Math.sqrt(((double)nbt.func_74762_e("x") - player.field_70165_t) * ((double)nbt.func_74762_e("x") - player.field_70165_t) + ((double)nbt.func_74762_e("z") - player.field_70161_v) * ((double)nbt.func_74762_e("z") - player.field_70161_v))) < 5.0) {
            return false;
        }
        nbt.func_74768_a("x", (int)player.field_70165_t);
        nbt.func_74768_a("z", (int)player.field_70161_v);
        boolean result = false;
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        if (ItemArmorBase.tryChargeStatic(armor, ConfigHandler.stPriority[0], distance, prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeStatic(armor, ConfigHandler.stPriority[1], distance, prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeStatic(armor, ConfigHandler.stPriority[2], distance, prod)) {
            result = true;
        } else if (ItemArmorBase.tryChargeStatic(armor, ConfigHandler.stPriority[3], distance, prod)) {
            result = true;
        }
        return result;
    }

    private static boolean tryChargeStatic(ItemStack[] armor, int slot, double distance, int prod) {
        if (armor[slot] == null || !(armor[slot].func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        return ElectricItem.manager.charge(armor[slot], (double)(Math.min(3, (int)distance / 5) + prod), Integer.MAX_VALUE, true, false) > 0.0;
    }
}

