/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.config.ConfigHandler;
import com.zuxelus.comboarmors.items.armor.IJetpack;
import com.zuxelus.comboarmors.items.armor.ItemArmorElectricUtility;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import ic2.core.IC2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class ItemArmorBaseJetpack
extends ItemArmorElectricUtility
implements IJetpack {
    public ItemArmorBaseJetpack(int renderIndex, int piece, int maxCharge, int transferLimit, int tier, boolean share) {
        super(renderIndex, piece, maxCharge, transferLimit, tier, share);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (player.field_71071_by.func_70440_f(2) != stack) {
            return;
        }
        NBTTagCompound nbtData = ItemNBTHelper.getOrCreateNbtData(stack);
        if (nbtData.func_74767_n("isFlyActive")) {
            return;
        }
        if (!nbtData.func_74764_b("jetpack")) {
            nbtData.func_74757_a("jetpack", true);
        }
        boolean jetpack = nbtData.func_74767_n("jetpack");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        boolean jetpackUsed = false;
        if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("hoverMode", hoverMode);
                if (hoverMode) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.hover_mode_enabled", new Object[0]));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.hover_mode_disabled", new Object[0]));
                }
            }
        }
        if (IC2.keyboard.isBoostKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = jetpack = !jetpack;
            if (IC2.platform.isSimulating()) {
                nbtData.func_74757_a("jetpack", jetpack);
                if (jetpack) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.jetpack_enabled", new Object[0]));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.jetpack_disabled", new Object[0]));
                }
            }
        }
        if (jetpack && (IC2.keyboard.isJumpKeyDown(player) || hoverMode)) {
            jetpackUsed = this.useJetpack(player, hoverMode, true, nbtData.func_74767_n("isFlyActive"));
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        this.playAudioSource(player, jetpackUsed);
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    private boolean useJetpack(EntityPlayer player, boolean hoverMode, boolean electric, boolean boost) {
        double consume;
        float dropPercentage;
        ItemStack jetpack = player.field_71071_by.func_70440_f(2);
        if (ItemArmorBaseJetpack.getCharge(jetpack) <= 0.0) {
            return false;
        }
        float power = electric ? 0.7f : 1.0f;
        float f = dropPercentage = electric ? 0.05f : 0.2f;
        if (ItemArmorBaseJetpack.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (ItemArmorBaseJetpack.getCharge(jetpack) / this.getMaxCharge(jetpack) * (double)dropPercentage));
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster;
            float f2 = retruster = hoverMode ? 1.0f : 0.15f;
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                if (boost) {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.1f);
                } else {
                    player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
                }
            }
        }
        int worldHeight = IC2.getWorldHeight((World)player.func_130014_f_());
        float y = (float)player.field_70163_u;
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        if (y > (float)(maxFlightHeight - 25)) {
            if (y > (float)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = power * ((float)maxFlightHeight - y) / 25.0f;
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IC2.keyboard.isJumpKeyDown(player)) {
                float f3 = maxHoverY = electric ? 0.1f : 0.2f;
            }
            if (IC2.keyboard.isSneakKeyDown(player)) {
                float f4 = maxHoverY = electric ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double d = consume = hoverMode ? 1.0 : 2.0;
        if (electric) {
            consume = ConfigHandler.jetpackEUAmount;
        }
        if (boost) {
            consume += (double)ConfigHandler.turbineEUAmount;
        }
        if (!player.field_70122_E) {
            ItemArmorBaseJetpack.discharge(jetpack, consume);
        }
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    @Override
    public void onFlyKeyPressed(EntityPlayer player, ItemStack stack) {
        this.flyKeyPressed(player, stack);
    }
}

