/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.armor.IJetpack;
import com.zuxelus.comboarmors.items.armor.ItemArmorElectricUtility;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorExoQuantum
extends ItemArmorElectricUtility
implements IMetalArmor,
IJetpack {
    public ItemArmorExoQuantum(int renderIndex, int piece) {
        super(renderIndex, piece, 10000000, 12000, 4, false);
        if (piece == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == ModItems.exoQuantumHelm || stack.func_77973_b() == ModItems.exoQuantumChest || stack.func_77973_b() == ModItems.exoQuantumBoots) {
            return "comboarmors:textures/armor/exo_quantum_1.png";
        }
        return "comboarmors:textures/armor/exo_quantum_2.png";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return this.field_77881_a == 1 ? 1.1 : 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public int getItemTier() {
        return 4;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(entity, armor, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public boolean isMetalArmor(ItemStack stack, EntityPlayer player) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbtData = ItemNBTHelper.getOrCreateNbtData(stack);
        boolean updated = false;
        switch (this.field_77881_a) {
            case 0: {
                if (ItemArmorExoQuantum.onHelmetTick(player, stack)) {
                    updated = true;
                }
                if (!ItemArmorExoQuantum.onNightvisionTick(player, stack)) break;
                updated = true;
                break;
            }
            case 1: {
                updated = this.onQuantumJetpackTick(player, nbtData);
                break;
            }
            case 2: {
                updated = this.onQuantumLeggingsTick(player, stack, nbtData);
                break;
            }
            case 3: {
                updated = this.onQuantumBootsTick(player, stack);
            }
        }
        if (updated) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        this.onFall(event, true);
    }

    private boolean onQuantumLeggingsTick(EntityPlayer player, ItemStack stack, NBTTagCompound nbtData) {
        boolean result = false;
        boolean enableQuantumSpeedOnSprint = true;
        if (IC2.platform.isRendering()) {
            enableQuantumSpeedOnSprint = ConfigUtil.getBool((Config)MainConfig.get(), (String)"misc/quantumSpeedOnSprint");
        }
        if (ElectricItem.manager.canUse(stack, 1000.0) && (player.field_70122_E || player.func_70090_H()) && IC2.keyboard.isForwardKeyDown(player) && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) {
            byte speedTicker = nbtData.func_74771_c("speedTicker");
            if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                speedTicker = 0;
                ElectricItem.manager.use(stack, 1000.0, null);
                result = true;
            }
            nbtData.func_74774_a("speedTicker", speedTicker);
            float speed = 0.22f;
            if (player.func_70090_H()) {
                speed = 0.1f;
                if (IC2.keyboard.isJumpKeyDown(player)) {
                    player.field_70181_x += (double)0.1f;
                }
            }
            if (speed > 0.0f) {
                player.func_70060_a(0.0f, 1.0f, speed);
            }
        }
        return result;
    }

    @Override
    public void onFlyKeyPressed(EntityPlayer player, ItemStack stack) {
        this.flyKeyPressed(player, stack);
    }
}

