/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.items.armor;

import com.zuxelus.comboarmors.items.armor.ItemArmorBase;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.util.Util;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public abstract class ItemArmorTankUtility
extends ItemArmorBase
implements ISpecialArmor,
IFluidContainerItem {
    protected final int capacity;
    protected final Fluid allowfluid;

    public ItemArmorTankUtility(int renderIndex, int piece, Fluid allowfluid, int capacity) {
        super(renderIndex, piece);
        this.capacity = capacity;
        this.allowfluid = allowfluid;
        this.func_77656_e(27);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            list.add("< " + FluidRegistry.getFluidName((FluidStack)fs) + ", " + fs.amount + "/" + this.getCapacity(stack) + " mB >");
        } else {
            list.add("< 0/" + this.getCapacity(stack) + " mB >");
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    protected void fillTank(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = tag.func_74775_l("Fluid");
        FluidStack fs = new FluidStack(this.allowfluid, this.getCapacity(stack));
        fs.writeToNBT(fluidTag);
        tag.func_74782_a("Fluid", (NBTBase)fluidTag);
    }

    protected int getCharge(ItemStack stack) {
        if (this.getFluid(stack) == null) {
            return 0;
        }
        int ret = this.getFluid((ItemStack)stack).amount;
        return ret > 0 ? ret : 0;
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack stack) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        if (tag.func_74764_b("addCapacity")) {
            return this.capacity + tag.func_74762_e("addCapacity");
        }
        tag.func_74768_a("addCapacity", 0);
        return this.capacity;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() != this.allowfluid) {
            return 0;
        }
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = tag.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            fs = new FluidStack(resource, 0);
        }
        if (!fs.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(this.getCapacity(stack) - fs.amount, resource.amount);
        if (doFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(fluidTag);
            tag.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        this.updateDamage(stack);
        return amount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        if (stack.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = tag.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            return null;
        }
        maxDrain = Math.min(fs.amount, maxDrain);
        if (doDrain) {
            fs.amount -= maxDrain;
            if (fs.amount <= 0) {
                tag.func_82580_o("Fluid");
            } else {
                fs.writeToNBT(fluidTag);
                tag.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        this.updateDamage(stack);
        return new FluidStack(fs, maxDrain);
    }

    public void updateDamage(ItemStack stack) {
        stack.func_77964_b(stack.func_77958_k() - 1 - (int)Util.map((double)this.getCharge(stack), (double)this.getCapacity(stack), (double)(stack.func_77958_k() - 2)));
    }
}

