/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.network;

import com.zuxelus.comboarmors.ComboArmors;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import ic2.api.item.ElectricItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class PacketOverchargeKeyPressed
implements IMessage,
IMessageHandler<PacketOverchargeKeyPressed, IMessage> {
    private double x;
    private double y;
    private double z;

    public PacketOverchargeKeyPressed() {
    }

    public PacketOverchargeKeyPressed(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public IMessage onMessage(PacketOverchargeKeyPressed message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ItemStack armor = player.field_71071_by.func_70440_f(2);
        if (armor != null && ComboArmors.chests.contains(armor.func_77977_a())) {
            PacketOverchargeKeyPressed.overcharge((EntityPlayer)player, armor, message.x, message.y, message.z);
        }
        return null;
    }

    private static void overcharge(EntityPlayer player, ItemStack stack, double x, double y, double z) {
        NBTTagCompound tag = ItemNBTHelper.getOrCreateNbtData(stack);
        int charge = tag.func_74762_e("charge");
        int maxcharge = tag.func_74762_e("maxCharge");
        int overchargenumber = maxcharge / 10;
        int boltnumber = overchargenumber / 10000;
        if (boltnumber < 1) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.not_have_charge", new Object[]{stack.func_82833_r()}));
            return;
        }
        if (boltnumber >= 10) {
            boltnumber = 10;
        }
        if (charge >= boltnumber * 10000) {
            for (int i = 1; i <= boltnumber; ++i) {
                EntityLightningBolt elb = new EntityLightningBolt(player.field_70170_p, x, y, z);
                player.field_70170_p.func_72838_d((Entity)elb);
                ElectricItem.manager.discharge(stack, 10000.0, 4, true, false, false);
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.discharged", new Object[]{boltnumber * 10000}));
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("info.not_enough_energy_discharge", new Object[0]));
        }
    }
}

