/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.recipes;

import com.zuxelus.comboarmors.recipes.RecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ArmorAssemblerRecipes {
    private static Map<Input, ItemStack> recipes = new HashMap<Input, ItemStack>();
    private static List<Item> items = new ArrayList<Item>();

    public static Map<Input, ItemStack> getRecipeList() {
        return recipes;
    }

    public static void addAssemblyRecipe(ItemStack result, ItemStack input1, Item input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(result.func_77946_l(), input1.func_77946_l(), new ItemStack(input2));
    }

    public static void addAssemblyRecipe(Item result, Item input1, ItemStack input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(new ItemStack(result), new ItemStack(input1), input2.func_77946_l());
    }

    public static void addAssemblyRecipe(Item result, ItemStack input1, Item input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(new ItemStack(result), input1.func_77946_l(), new ItemStack(input2));
    }

    public static void addAssemblyRecipe(Item result, Item input1, Item input2) {
        ArmorAssemblerRecipes.addAssemblyRecipe(new ItemStack(result), new ItemStack(input1), new ItemStack(input2));
    }

    public static void addAssemblyRecipe(ItemStack result, ItemStack input1, ItemStack input2) {
        ArmorAssemblerRecipes.addRecipe(result, input1, input2);
        if (!items.contains(input1.func_77973_b())) {
            items.add(input1.func_77973_b());
        }
        if (!items.contains(input2.func_77973_b())) {
            items.add(input2.func_77973_b());
        }
    }

    private static void addRecipe(ItemStack result, ItemStack input1, ItemStack input2) {
        if (result == null) {
            throw new NullPointerException("The recipe output is null");
        }
        if (input1 == null) {
            throw new NullPointerException("The I1 recipe input is null");
        }
        if (input2 == null) {
            throw new NullPointerException("The I2 recipe input is null");
        }
        InventoryBasic inv = new InventoryBasic(null, false, 2);
        ItemStack output = result.func_77946_l();
        inv.func_70299_a(0, input1);
        inv.func_70299_a(1, input2);
        RecipeHandler.onCrafting(output, (IInventory)inv);
        recipes.put(new Input(input1, input2), output);
        recipes.put(new Input(input2, input1), output);
    }

    public static List<Item> getItemList() {
        return items;
    }

    public static ItemStack getAssemblyResult(ItemStack input1, ItemStack input2) {
        if (input1 == null || input2 == null) {
            return null;
        }
        for (Map.Entry<Input, ItemStack> entry : recipes.entrySet()) {
            Input input = entry.getKey();
            if (!input.matches(input1, input2)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static class Input {
        public final ItemStack i1;
        public final ItemStack i2;

        public Input(ItemStack input1, ItemStack input2) {
            this.i1 = input1;
            this.i2 = input2;
        }

        public boolean matches(ItemStack input1, ItemStack input2) {
            return this.i1.func_77973_b() == input1.func_77973_b() && this.i2.func_77973_b() == input2.func_77973_b();
        }
    }
}

