/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.tileentities;

import com.zuxelus.comboarmors.init.ModItems;
import com.zuxelus.comboarmors.items.IItemUpgrade;
import com.zuxelus.comboarmors.items.IItemUpgradeable;
import com.zuxelus.comboarmors.items.ItemUpgrade;
import com.zuxelus.comboarmors.items.armor.ItemArmorTankUtility;
import com.zuxelus.comboarmors.recipes.ArmorAssemblerRecipes;
import com.zuxelus.comboarmors.recipes.RecipeHandler;
import com.zuxelus.comboarmors.tileentities.TileEntityEnergySink;
import com.zuxelus.comboarmors.utils.ItemNBTHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.tile.IWrenchable;
import ic2.core.Ic2Items;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityArmorAssembler
extends TileEntityEnergySink
implements IWrenchable {
    public static final int SLOT_INPUT1 = 0;
    public static final int SLOT_INPUT2 = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_UPGRADE = 3;
    public static final int SLOT_DISCHARGER = 4;
    public static final int TIER = 2;
    public static final int CAPACITY = 50000;
    public static final int OUTPUT = 128;
    public static final int CONSUMPTION = 32;
    public static final int TIMEFACTOR = 14;
    private int production;
    private int productionMax;
    private boolean active;

    public TileEntityArmorAssembler() {
        super("tile.armor_assembler.name", 2, 128, 50000);
        this.addedToEnet = false;
        this.active = false;
        this.production = 0;
        this.productionMax = 0;
    }

    public int getProduction() {
        return this.production;
    }

    public int getProductionFactor() {
        if (this.productionMax == 0) {
            return 0;
        }
        return Math.round(this.production / this.productionMax * 24);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTimeString() {
        int hours;
        int seconds;
        if (this.productionMax <= 0) {
            return I18n.func_135052_a((String)"info.remaining", (Object[])new Object[]{"0:00:00"});
        }
        int mtime = this.productionMax / 280;
        int time = this.production / 280;
        int timeleft = mtime - time;
        int minutes = timeleft / 60;
        String s = (seconds = timeleft - ((minutes -= (hours = minutes / 60) * 60) * 60 + hours * 3600)) < 10 ? ":0" : ":";
        String s2 = minutes < 10 ? ":0" : ":";
        return I18n.func_135052_a((String)"info.remaining", (Object[])new Object[]{"" + hours + s2 + minutes + s + seconds});
    }

    public boolean getActive() {
        return this.active;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("energy") || !tag.func_74764_b("production")) break;
                this.energy = tag.func_74769_h("energy");
                this.production = tag.func_74762_e("production");
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.writeProperties(tag);
        tag.func_74757_a("active", this.active);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.readProperties(pkt.func_148857_g());
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("production")) {
            this.production = tag.func_74762_e("production");
        }
        if (tag.func_74764_b("productionMax")) {
            this.productionMax = tag.func_74762_e("productionMax");
        }
        if (tag.func_74764_b("active")) {
            boolean old = this.active;
            this.active = tag.func_74767_n("active");
            if (this.field_145850_b.field_72995_K && this.active != old) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("production", this.production);
        tag.func_74768_a("productionMax", this.productionMax);
        return tag;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeProperties(tag);
    }

    @Override
    public void onLoad() {
        if (!this.addedToEnet && this.field_145850_b != null && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
            this.updateActive();
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.onLoad();
        this.handleDischarger(4);
        ItemStack stack = this.func_70301_a(3);
        if (stack != null && stack.func_77973_b() == ModItems.creativeUpgrade && this.productionMax > 0) {
            this.combineItem();
            this.production = 0;
            this.updateState();
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.energy >= 32.0) {
            this.energy -= 32.0;
            this.production += 14;
            if (this.production >= this.productionMax) {
                this.combineItem();
                this.production = 0;
                this.updateState();
            }
        } else {
            this.energy = 0.0;
            this.production = 0;
            this.updateState();
        }
    }

    public void notifyBlockUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateState();
    }

    private void updateActive() {
        this.active = false;
        this.updateMaxProgress();
        if (this.energy < 32.0) {
            return;
        }
        this.active = this.canCombine();
    }

    private void updateState() {
        boolean old = this.active;
        int oldProductionMax = this.productionMax;
        this.updateActive();
        if (this.active != old) {
            this.production = 0;
            this.notifyBlockUpdate();
            return;
        }
        if (oldProductionMax != this.productionMax) {
            this.notifyBlockUpdate();
        }
    }

    private boolean canCombine() {
        ItemStack input1 = this.func_70301_a(0);
        ItemStack input2 = this.func_70301_a(1);
        if (input1 == null || input2 == null) {
            return false;
        }
        ItemStack result = ArmorAssemblerRecipes.getAssemblyResult(input1, input2);
        if (result == null) {
            return false;
        }
        ItemStack output = this.func_70301_a(2);
        return output == null;
    }

    private void combineItem() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.canCombine()) {
            return;
        }
        ItemStack input1 = this.func_70301_a(0);
        ItemStack input2 = this.func_70301_a(1);
        ItemStack result = ArmorAssemblerRecipes.getAssemblyResult(input1, input2);
        ItemStack output = result.func_77946_l();
        RecipeHandler.onCrafting(output, (IInventory)this);
        int charge = 0;
        NBTTagCompound nbtout = ItemNBTHelper.getOrCreateNbtData(output);
        NBTTagCompound nbtin1 = ItemNBTHelper.getOrCreateNbtData(input1);
        NBTTagCompound nbtin2 = ItemNBTHelper.getOrCreateNbtData(input2);
        charge += nbtin1.func_74762_e("charge");
        if ((charge += nbtin2.func_74762_e("charge")) > nbtout.func_74762_e("maxCharge")) {
            charge = nbtout.func_74762_e("maxCharge");
        }
        nbtout.func_74768_a("charge", charge);
        RecipeHandler.updateElectricDamageBars(output);
        this.func_70299_a(2, output);
        --input1.field_77994_a;
        if (input1.field_77994_a <= 0) {
            this.func_70299_a(0, null);
        }
        --input2.field_77994_a;
        if (input2.field_77994_a <= 0) {
            this.func_70299_a(1, null);
        }
    }

    private void updateMaxProgress() {
        IItemUpgradeable item;
        ItemStack input2;
        ItemStack input1 = this.func_70301_a(0);
        ItemStack result = ArmorAssemblerRecipes.getAssemblyResult(input1, input2 = this.func_70301_a(1));
        if (result == null) {
            this.productionMax = 0;
            return;
        }
        int upgradeSlot = -1;
        if (input1.func_77973_b() instanceof IItemUpgrade || input1.func_77969_a(Ic2Items.overclockerUpgrade) || input1.func_77969_a(Ic2Items.energyStorageUpgrade) || input1.func_77969_a(Ic2Items.transformerUpgrade)) {
            upgradeSlot = 1;
        }
        if (input2.func_77973_b() instanceof IItemUpgrade || input2.func_77969_a(Ic2Items.overclockerUpgrade) || input2.func_77969_a(Ic2Items.energyStorageUpgrade) || input2.func_77969_a(Ic2Items.transformerUpgrade)) {
            upgradeSlot = 2;
        }
        if (upgradeSlot == -1) {
            item = (IItemUpgradeable)result.func_77973_b();
            int tier = item.getItemTier();
            int mins = tier * 10;
            int secs = mins * 60;
            int ticks = secs * 20;
            this.productionMax = ticks * 14;
        } else if (result.func_77973_b() instanceof IItemUpgradeable) {
            item = (IItemUpgradeable)result.func_77973_b();
            int modifier = 1;
            if (upgradeSlot == 1 && input1.func_77973_b() instanceof ItemUpgrade) {
                modifier = ((ItemUpgrade)input1.func_77973_b()).getStackModifier(input1);
            }
            if (upgradeSlot == 2 && input2.func_77973_b() instanceof ItemUpgrade) {
                modifier = ((ItemUpgrade)input2.func_77973_b()).getStackModifier(input2);
            }
            int tier = item.getItemTier();
            int mins = tier * 5;
            int secs = mins * 60;
            int ticks = secs * 20;
            int eu = ticks * 14;
            int num = 0;
            if (upgradeSlot == 1) {
                num = input1.field_77994_a * modifier;
            }
            if (upgradeSlot == 2) {
                num = input2.field_77994_a * modifier;
            }
            double min = (double)num * 1.875;
            double sec = min * 60.0;
            double tick = sec * 20.0;
            int eu2 = (int)tick * 14;
            this.productionMax = eu + eu2;
        } else if (result.func_77973_b() instanceof ItemArmorTankUtility) {
            this.productionMax = 252000;
        }
        ItemStack upgrade = this.func_70301_a(3);
        if (upgrade != null && upgrade.func_77973_b() == ModItems.overclockerUpgrade) {
            this.productionMax /= upgrade.field_77994_a + 1;
        }
    }

    public int func_70302_i_() {
        return 5;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 0: 
            case 1: {
                return ArmorAssemblerRecipes.getItemList().contains(stack.func_77973_b());
            }
            case 3: {
                return stack.func_77973_b() == ModItems.overclockerUpgrade || stack.func_77973_b() == ModItems.creativeUpgrade;
            }
            case 4: {
                return ElectricItem.manager.discharge(stack, Double.POSITIVE_INFINITY, this.tier, true, true, true) > 0.0;
            }
        }
        return false;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double old = this.energy;
        this.energy += amount;
        double left = 0.0;
        if (this.energy > this.capacity) {
            left = this.energy - this.capacity;
            this.energy = this.capacity;
        }
        if (this.energy > 0.0 && old == 0.0 && !this.field_145850_b.field_72995_K) {
            this.updateState();
        }
        return left;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.facing.ordinal() != side;
    }

    public short getFacing() {
        return (short)this.facing.ordinal();
    }

    public void setFacing(short facing) {
        this.setFacing((int)facing);
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModItems.armorAssembler);
    }
}

