/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.tileentities;

import com.zuxelus.comboarmors.containers.ISlotItemFilter;
import com.zuxelus.comboarmors.tileentities.ITilePacketHandler;
import com.zuxelus.comboarmors.tileentities.TileEntityInventory;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityEnergySink
extends TileEntityInventory
implements IEnergySink,
ISlotItemFilter,
ITilePacketHandler {
    protected boolean addedToEnet = false;
    protected int tier;
    protected int output;
    protected double energy = 0.0;
    protected double capacity;

    public TileEntityEnergySink(String name, int tier, int output, int capacity) {
        super(name);
        this.tier = tier;
        this.output = output;
        this.capacity = capacity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getEnergyFactor() {
        return (int)Math.round(this.energy / this.capacity * 14.0);
    }

    public String getEnergyString() {
        return "" + (int)(Math.min(1.0, this.energy / this.capacity) * 100.0) + "%";
    }

    public int getOutput() {
        return this.output;
    }

    @Override
    public void setFacing(int meta) {
        this.onChunkUnload();
        super.setFacing(meta);
        this.onLoad();
    }

    public void setEnergy(double value) {
        this.energy = Math.min(value, this.capacity);
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        this.energy = tag.func_74769_h("energy");
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74780_a("energy", this.energy);
        return tag;
    }

    public void onLoad() {
        if (!this.addedToEnet && this.field_145850_b != null && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && this.field_145850_b != null && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    protected void handleDischarger(int slot) {
        IElectricItem ielectricitem;
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && this.energy < this.capacity && stack.func_77973_b() instanceof IElectricItem && (ielectricitem = (IElectricItem)stack.func_77973_b()).canProvideEnergy(stack)) {
            this.energy += ElectricItem.manager.discharge(stack, this.capacity - this.energy, this.tier, false, false, false);
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection dir) {
        return dir != this.getFacingForge();
    }

    public double getDemandedEnergy() {
        return Math.min(this.capacity - this.energy, (double)this.output);
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= this.capacity) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }
}

