/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.comboarmors.tileentities;

import com.zuxelus.comboarmors.tileentities.TileEntityFacing;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public abstract class TileEntityInventory
extends TileEntityFacing
implements ISidedInventory {
    protected ItemStack[] inventory;
    protected String customName;

    public TileEntityInventory(String name) {
        this.customName = name;
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stackTag = nbttaglist.func_150305_b(i);
            this.inventory[stackTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        NBTTagList list = new NBTTagList();
        for (byte i = 0; i < this.func_70302_i_(); i = (byte)((byte)(i + 1))) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", i);
            stack.func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        return tag;
    }

    public String func_145825_b() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.func_70302_i_() ? this.inventory[index] : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = TileEntityInventory.getAndSplit(this.inventory, index, count);
        return itemstack;
    }

    private static ItemStack getAndSplit(ItemStack[] stacks, int index, int amount) {
        if (index >= 0 && index < stacks.length && stacks[index] != null && amount > 0) {
            ItemStack itemstack = stacks[index].func_77979_a(amount);
            if (stacks[index].field_77994_a == 0) {
                stacks[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = this.func_70301_a(index);
        if (itemstack == null) {
            return null;
        }
        this.inventory[index] = null;
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public List<ItemStack> getDrops(int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            list.add(stack);
        }
        return list;
    }

    public void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public int[] func_94128_d(int side) {
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }
}

