/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.client.Mappings;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import uk.co.electronstudio.sdl2gdx.SDL2Controller;

public class Controller {
    private String cachedName;
    private Mappings.Entry mapping;
    private SDL2Controller controller;
    private ButtonStates states;

    public Controller(SDL2Controller controller) {
        this.controller = controller;
        this.states = new ButtonStates();
        this.getName();
    }

    public SDL2Controller getSDL2Controller() {
        return this.controller;
    }

    public ButtonStates getButtonsStates() {
        return this.states;
    }

    public String getName() {
        if (this.controller.isConnected()) {
            if (this.cachedName == null) {
                this.cachedName = this.controller.getName().replace("SDL GameController ", "").replace("SDL Joystick ", "");
            }
            return this.cachedName;
        }
        return I18n.func_135052_a((String)"controllable.toast.controller", (Object[])new Object[0]);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public float getLTriggerValue() {
        return this.controller.getAxis(4);
    }

    public float getRTriggerValue() {
        return this.controller.getAxis(5);
    }

    public float getLThumbStickXValue() {
        return this.controller.getAxis(0);
    }

    public float getLThumbStickYValue() {
        return this.controller.getAxis(1);
    }

    public float getRThumbStickXValue() {
        return this.controller.getAxis(2);
    }

    public float getRThumbStickYValue() {
        return this.controller.getAxis(3);
    }

    public void setMapping(Mappings.Entry mapping) {
        this.mapping = mapping;
    }

    @Nullable
    public Mappings.Entry getMapping() {
        return this.mapping;
    }
}

