/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Controllable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ControllerProperties {
    private static File file;
    private static boolean loaded;
    private static String lastController;
    private static String selectedMapping;

    public static void load(File configFolder) {
        if (!loaded) {
            Properties properties = new Properties();
            file = new File(configFolder, "controllable/controller.properties");
            try {
                if (file.createNewFile()) {
                    Controllable.LOGGER.info("Successfully created controller properties");
                }
                if (file.exists()) {
                    properties.load(new FileInputStream(file));
                    lastController = properties.getProperty("CurrentController", "");
                    selectedMapping = properties.getProperty("SelectedMapping", "");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            loaded = true;
        }
    }

    static void save() {
        if (!loaded) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("LastController", lastController);
        properties.setProperty("SelectedMapping", selectedMapping);
        try {
            properties.store(new FileOutputStream(file), "Controller Properties");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getLastController() {
        return lastController;
    }

    public static void setLastController(String lastController) {
        ControllerProperties.lastController = lastController;
    }

    public static String getSelectedMapping() {
        return selectedMapping;
    }

    public static void setSelectedMapping(String selectedMapping) {
        ControllerProperties.selectedMapping = selectedMapping;
    }

    static {
        loaded = false;
        lastController = "";
        selectedMapping = "";
    }
}

